/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth.token;

import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.provider.endpoint.TokenEndpoint;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/oauth/token"})
public class UaaTokenEndpoint
extends TokenEndpoint {
    private Boolean allowQueryString = null;

    public UaaTokenEndpoint() {
        this.setAllowedRequestMethods(new HashSet<HttpMethod>(Arrays.asList(HttpMethod.GET, HttpMethod.POST)));
    }

    public boolean isAllowQueryString() {
        return this.allowQueryString == null ? true : this.allowQueryString;
    }

    public void setAllowQueryString(boolean allowQueryString) {
        this.allowQueryString = allowQueryString;
        if (allowQueryString) {
            this.setAllowedRequestMethods(new HashSet<HttpMethod>(Arrays.asList(HttpMethod.GET, HttpMethod.POST)));
        } else {
            this.setAllowedRequestMethods(Collections.singleton(HttpMethod.POST));
        }
    }

    @RequestMapping(value={"**"}, method={RequestMethod.GET})
    public ResponseEntity<OAuth2AccessToken> doDelegateGet(Principal principal, @RequestParam Map<String, String> parameters) throws HttpRequestMethodNotSupportedException {
        return this.getAccessToken(principal, parameters);
    }

    @RequestMapping(value={"**"}, method={RequestMethod.POST})
    public ResponseEntity<OAuth2AccessToken> doDelegatePost(Principal principal, @RequestParam Map<String, String> parameters, HttpServletRequest request) throws HttpRequestMethodNotSupportedException {
        if (StringUtils.hasText((String)request.getQueryString()) && !this.isAllowQueryString()) {
            this.logger.debug((Object)"Call to /oauth/token contains a query string. Aborting.");
            throw new HttpRequestMethodNotSupportedException("POST");
        }
        return this.postAccessToken(principal, parameters);
    }

    @RequestMapping(value={"**"})
    public void methodsNotAllowed(HttpServletRequest request) throws HttpRequestMethodNotSupportedException {
        throw new HttpRequestMethodNotSupportedException(request.getMethod());
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public ResponseEntity<OAuth2Exception> handleHttpRequestMethodNotSupportedException(HttpRequestMethodNotSupportedException e) throws Exception {
        ResponseEntity result = super.handleHttpRequestMethodNotSupportedException(e);
        if (HttpMethod.POST.matches(e.getMethod())) {
            OAuth2Exception cause = new OAuth2Exception("Parameters must be passed in the body of the request", ((OAuth2Exception)result.getBody()).getCause()){

                public String getOAuth2ErrorCode() {
                    return "query_string_not_allowed";
                }

                public int getHttpErrorCode() {
                    return HttpStatus.NOT_ACCEPTABLE.value();
                }
            };
            result = new ResponseEntity((Object)cause, (MultiValueMap)result.getHeaders(), HttpStatus.NOT_ACCEPTABLE);
        }
        return result;
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<OAuth2Exception> handleException(Exception e) throws Exception {
        this.logger.error((Object)("Handling error: " + e.getClass().getSimpleName() + ", " + e.getMessage()), (Throwable)e);
        return this.getExceptionTranslator().translate(e);
    }

    public void setAllowedRequestMethods(Set<HttpMethod> allowedRequestMethods) {
        if (this.isAllowQueryString()) {
            super.setAllowedRequestMethods(allowedRequestMethods);
        } else {
            super.setAllowedRequestMethods(Collections.singleton(HttpMethod.POST));
        }
    }
}

