/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.util;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriUtils;

public abstract class UaaUrlUtils {
    private static final Pattern allowedRedirectUriPattern = Pattern.compile("^http(\\*|s)?://(.*:.*@)?(([a-zA-Z0-9\\-\\*]+\\.)*[a-zA-Z0-9\\-]+\\.)?[a-zA-Z0-9\\-]+(:[0-9]+)?(/.*|$)");

    public static String getUaaUrl() {
        return UaaUrlUtils.getUaaUrl("");
    }

    public static String getUaaUrl(String path) {
        return UaaUrlUtils.getUaaUrl(path, false);
    }

    public static String getUaaUrl(String path, boolean zoneSwitchPossible) {
        return UaaUrlUtils.getURIBuilder(path, zoneSwitchPossible).build().toUriString();
    }

    public static String getUaaHost() {
        return UaaUrlUtils.getURIBuilder("").build().getHost();
    }

    public static UriComponentsBuilder getURIBuilder(String path) {
        return UaaUrlUtils.getURIBuilder(path, false);
    }

    public static UriComponentsBuilder getURIBuilder(String path, boolean zoneSwitchPossible) {
        UriComponentsBuilder builder = ServletUriComponentsBuilder.fromCurrentContextPath().path(path);
        if (zoneSwitchPossible) {
            String host = builder.build().getHost();
            IdentityZone current = IdentityZoneHolder.get();
            if (host != null && !IdentityZoneHolder.isUaa() && !host.startsWith(current.getSubdomain() + ".")) {
                host = current.getSubdomain() + "." + host;
                builder.host(host);
            }
        }
        return builder;
    }

    public static boolean isValidRegisteredRedirectUrl(String url) {
        if (StringUtils.hasText((String)url)) {
            return allowedRedirectUriPattern.matcher(url).matches();
        }
        return false;
    }

    public static String findMatchingRedirectUri(Collection<String> redirectUris, String requestedRedirectUri, String fallbackRedirectUri) {
        AntPathMatcher matcher = new AntPathMatcher();
        for (String pattern : (Collection)Optional.ofNullable(redirectUris).orElse(Collections.emptyList())) {
            if (!matcher.match(pattern, requestedRedirectUri)) continue;
            return requestedRedirectUri;
        }
        return Optional.ofNullable(fallbackRedirectUri).orElse(requestedRedirectUri);
    }

    public static String getHostForURI(String uri) {
        UriComponentsBuilder b = UriComponentsBuilder.fromHttpUrl((String)uri);
        return b.build().getHost();
    }

    public static String getBaseURL(HttpServletRequest request) {
        String requestURL = request.getRequestURL().toString();
        return StringUtils.hasText((String)request.getServletPath()) ? requestURL.substring(0, requestURL.lastIndexOf(request.getServletPath())) : requestURL;
    }

    public static Map<String, String[]> getParameterMap(String uri) {
        UriComponentsBuilder b = UriComponentsBuilder.fromUriString((String)uri);
        MultiValueMap map = b.build().getQueryParams();
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        map.entrySet().stream().forEach(e -> result.put((String)e.getKey(), UaaUrlUtils.decodeValue((List)e.getValue())));
        return result;
    }

    public static String[] decodeValue(List<String> value) {
        if (value == null) {
            return null;
        }
        String[] result = new String[value.size()];
        int pos = 0;
        for (String s : value) {
            try {
                result[pos++] = UriUtils.decode((String)s, (String)"UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException(s, e);
            }
        }
        return result;
    }

    public static boolean isUrl(String url) {
        if (StringUtils.isEmpty((Object)url)) {
            return false;
        }
        try {
            new URL(url);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static String addQueryParameter(String url, String name, String value) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)url);
        builder.queryParam(name, new Object[]{value});
        return builder.build().toUriString();
    }

    public static String addFragmentComponent(String urlString, String component) {
        URI uri = URI.create(urlString);
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.fragment(StringUtils.hasText((String)uri.getFragment()) ? uri.getFragment() + "&" + component : component);
        return builder.build().toUriString();
    }

    public static String addSubdomainToUrl(String url) {
        return UaaUrlUtils.addSubdomainToUrl(url, UaaUrlUtils.getSubdomain());
    }

    public static String addSubdomainToUrl(String url, String subdomain) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)url);
        builder.host(subdomain + builder.build().getHost());
        return builder.build().toUriString();
    }

    public static String getSubdomain() {
        String subdomain = IdentityZoneHolder.get().getSubdomain();
        if (StringUtils.hasText((String)subdomain)) {
            subdomain = subdomain + ".";
        }
        return subdomain.trim();
    }

    public static String extractPathVariableFromUrl(int pathParameterIndex, String path) {
        String[] paths;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((paths = StringUtils.delimitedListToStringArray((String)path, (String)"/")).length != 0 && pathParameterIndex < paths.length) {
            return paths[pathParameterIndex];
        }
        return null;
    }

    public static String getRequestPath(HttpServletRequest request) {
        String servletPath = request.getServletPath();
        String pathInfo = request.getPathInfo();
        if (servletPath == null) {
            servletPath = "";
        }
        if (pathInfo == null) {
            pathInfo = "";
        }
        String path = String.format("%s%s", servletPath, pathInfo);
        return path;
    }
}

