/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.web;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.springframework.http.MediaType;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.web.filter.OncePerRequestFilter;

public class LimitedModeUaaFilter
extends OncePerRequestFilter {
    public static final String ERROR_CODE = "uaa_unavailable";
    public static final String ERROR_MESSAGE = "UAA intentionally in limited mode, operation not permitted. Please try later.";
    private static Log logger = LogFactory.getLog(LimitedModeUaaFilter.class);
    private Set<String> permittedEndpoints = Collections.emptySet();
    private Set<String> permittedMethods = Collections.emptySet();
    private List<AntPathRequestMatcher> endpoints = Collections.emptyList();
    private boolean enabled = false;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (this.isEnabled()) {
            if (this.isMethodAllowed(request) || this.isEndpointAllowed(request)) {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            } else {
                logger.debug((Object)String.format("Operation Not permitted in limited mode for URL:%s and method:%s", request.getRequestURI(), request.getMethod()));
                Map<String, String> json = this.getErrorData();
                if (this.acceptsJson(request)) {
                    response.setStatus(503);
                    response.setHeader("Content-Type", "application/json");
                    response.getWriter().write(JsonUtils.writeValueAsString(json));
                    response.getWriter().flush();
                    response.getWriter().close();
                } else {
                    response.sendError(503, json.get("description"));
                }
            }
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    protected Map<String, String> getErrorData() {
        String error = ERROR_CODE;
        String description = ERROR_MESSAGE;
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("error", error);
        json.put("error_description", description);
        return json;
    }

    protected boolean acceptsJson(HttpServletRequest request) {
        List mediaTypes = MediaType.parseMediaTypes((String)request.getHeader("Accept"));
        return mediaTypes.stream().anyMatch(m -> m.isCompatibleWith(MediaType.APPLICATION_JSON));
    }

    protected boolean isMethodAllowed(HttpServletRequest request) {
        return this.getPermittedMethods().contains(request.getMethod().toUpperCase());
    }

    public boolean isEndpointAllowed(HttpServletRequest request) {
        return this.endpoints.stream().anyMatch(m -> m.matches(request));
    }

    public void setPermittedEndpoints(Set<String> permittedEndpoints) {
        this.permittedEndpoints = permittedEndpoints;
        this.endpoints = permittedEndpoints == null ? Collections.emptyList() : permittedEndpoints.stream().map(s -> new AntPathRequestMatcher(s)).collect(Collectors.toList());
    }

    public Set<String> getPermittedEndpoints() {
        return this.permittedEndpoints;
    }

    public Set<String> getPermittedMethods() {
        return this.permittedMethods;
    }

    public void setPermittedMethods(Set<String> permittedMethods) {
        this.permittedMethods = Optional.ofNullable(permittedMethods).orElse(Collections.emptySet());
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

