/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.audit.event;

import com.fasterxml.jackson.core.type.TypeReference;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.cloudfoundry.identity.uaa.audit.AuditEvent;
import org.cloudfoundry.identity.uaa.audit.AuditEventType;
import org.cloudfoundry.identity.uaa.audit.UaaAuditService;
import org.cloudfoundry.identity.uaa.oauth.UaaOauth2Authentication;
import org.cloudfoundry.identity.uaa.oauth.jwt.Jwt;
import org.cloudfoundry.identity.uaa.oauth.jwt.JwtHelper;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.util.UaaTokenUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.context.ApplicationEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationDetails;
import org.springframework.util.StringUtils;

public abstract class AbstractUaaEvent
extends ApplicationEvent {
    private static final long serialVersionUID = -7639844193401892160L;
    private final transient IdentityZone identityZone = IdentityZoneHolder.get();
    private Authentication authentication;

    protected AbstractUaaEvent(Object source) {
        super(source);
        if (source instanceof Authentication) {
            this.authentication = (Authentication)source;
        }
    }

    protected AbstractUaaEvent(Object source, Authentication authentication) {
        super(source);
        this.authentication = authentication;
    }

    public void process(UaaAuditService auditor) {
        auditor.log(this.getAuditEvent(), this.getAuditEvent().getIdentityZoneId());
    }

    protected AuditEvent createAuditRecord(String principalId, AuditEventType type, String origin) {
        return new AuditEvent(type, principalId, origin, null, System.currentTimeMillis(), this.identityZone.getId());
    }

    protected AuditEvent createAuditRecord(String principalId, AuditEventType type, String origin, String data) {
        return new AuditEvent(type, principalId, origin, data, System.currentTimeMillis(), this.identityZone.getId());
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    protected String getOrigin(Principal principal) {
        if (principal instanceof Authentication) {
            Authentication caller = (Authentication)principal;
            StringBuilder builder = new StringBuilder();
            if (caller instanceof OAuth2Authentication) {
                OAuth2Authentication oAuth2Authentication = (OAuth2Authentication)caller;
                builder.append("client=").append(oAuth2Authentication.getOAuth2Request().getClientId());
                if (!oAuth2Authentication.isClientOnly()) {
                    builder.append(", ").append("user=").append(oAuth2Authentication.getName());
                }
            } else {
                builder.append("caller=").append(caller.getName());
            }
            if (caller.getDetails() != null) {
                builder.append(", details=(");
                try {
                    Map map = (Map)JsonUtils.readValue((String)((String)caller.getDetails()), (TypeReference)new TypeReference<Map<String, Object>>(){});
                    if (map.containsKey("remoteAddress")) {
                        builder.append("remoteAddress=").append(map.get("remoteAddress")).append(", ");
                    }
                    builder.append("type=").append(caller.getDetails().getClass().getSimpleName());
                }
                catch (Exception e) {
                    builder.append(caller.getDetails());
                }
                this.appendTokenDetails(caller, builder);
                builder.append(")");
            }
            return builder.toString();
        }
        return principal == null ? null : principal.getName();
    }

    protected void appendTokenDetails(Authentication caller, StringBuilder builder) {
        String tokenValue = null;
        if (caller instanceof UaaOauth2Authentication) {
            tokenValue = ((UaaOauth2Authentication)caller).getTokenValue();
        } else if (caller.getDetails() instanceof OAuth2AuthenticationDetails) {
            tokenValue = ((OAuth2AuthenticationDetails)this.authentication.getDetails()).getTokenValue();
        }
        if (StringUtils.hasText((String)tokenValue)) {
            if (UaaTokenUtils.isJwtToken(tokenValue)) {
                try {
                    Jwt token = JwtHelper.decode(tokenValue);
                    Map claims = (Map)JsonUtils.readValue((String)token.getClaims(), (TypeReference)new TypeReference<Map<String, Object>>(){});
                    String issuer = claims.get("iss").toString();
                    String subject = claims.get("sub").toString();
                    builder.append(", sub=").append(subject).append(", ").append("iss=").append(issuer);
                }
                catch (Exception e) {
                    builder.append(", <token extraction failed>");
                }
            } else {
                builder.append(", opaque-token=present");
            }
        }
    }

    public abstract AuditEvent getAuditEvent();

    protected static Authentication getContextAuthentication() {
        Authentication a = SecurityContextHolder.getContext().getAuthentication();
        if (a == null) {
            a = new Authentication(){
                private static final long serialVersionUID = 1748694836774597624L;
                ArrayList<GrantedAuthority> authorities = new ArrayList();

                public Collection<? extends GrantedAuthority> getAuthorities() {
                    return this.authorities;
                }

                public Object getCredentials() {
                    return null;
                }

                public Object getDetails() {
                    return null;
                }

                public Object getPrincipal() {
                    return "null";
                }

                public boolean isAuthenticated() {
                    return false;
                }

                public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
                }

                public String getName() {
                    return "null";
                }
            };
        }
        return a;
    }

    public IdentityZone getIdentityZone() {
        return this.identityZone;
    }
}

