/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.mfa_provider;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.mfa_provider.InvalidMfaProviderException;
import org.cloudfoundry.identity.uaa.mfa_provider.MfaProvider;
import org.cloudfoundry.identity.uaa.mfa_provider.MfaProviderProvisioning;
import org.cloudfoundry.identity.uaa.mfa_provider.MfaProviderValidator;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/mfa-providers"})
@RestController
public class MfaProviderEndpoints
implements ApplicationEventPublisherAware {
    protected static Log logger = LogFactory.getLog(MfaProviderEndpoints.class);
    private ApplicationEventPublisher publisher;
    private MfaProviderProvisioning mfaProviderProvisioning;
    private MfaProviderValidator mfaProviderValidator;

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }

    @RequestMapping(method={RequestMethod.POST})
    public ResponseEntity<MfaProvider> createMfaProvider(@RequestBody MfaProvider provider) {
        String zoneId = IdentityZoneHolder.get().getId();
        provider.setIdentityZoneId(zoneId);
        this.mfaProviderValidator.validate(provider);
        if (!StringUtils.hasText((String)provider.getConfig().getIssuer())) {
            provider.getConfig().setIssuer(IdentityZoneHolder.get().getName());
        }
        MfaProvider created = this.mfaProviderProvisioning.create(provider, zoneId);
        return new ResponseEntity((Object)created, HttpStatus.CREATED);
    }

    public MfaProviderProvisioning getMfaProviderProvisioning() {
        return this.mfaProviderProvisioning;
    }

    public void setMfaProviderProvisioning(MfaProviderProvisioning mfaProviderProvisioning) {
        this.mfaProviderProvisioning = mfaProviderProvisioning;
    }

    public void setMfaProviderValidator(MfaProviderValidator mfaProviderValidator) {
        this.mfaProviderValidator = mfaProviderValidator;
    }

    @ExceptionHandler(value={InvalidMfaProviderException.class})
    public ResponseEntity<InvalidMfaProviderException> handleInvalidMfaProviderException(InvalidMfaProviderException e) {
        return new ResponseEntity((Object)e, HttpStatus.UNPROCESSABLE_ENTITY);
    }
}

