/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.audit.event.SystemDeletable;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;
import org.cloudfoundry.identity.uaa.oauth.token.RevocableToken;
import org.cloudfoundry.identity.uaa.oauth.token.RevocableTokenProvisioning;
import org.cloudfoundry.identity.uaa.scim.ScimUser;
import org.cloudfoundry.identity.uaa.scim.ScimUserProvisioning;
import org.cloudfoundry.identity.uaa.scim.exception.ScimResourceNotFoundException;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.cloudfoundry.identity.uaa.zone.MultitenantJdbcClientDetailsService;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.common.util.RandomValueStringGenerator;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.NoSuchClientException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.client.BaseClientDetails;
import org.springframework.security.oauth2.provider.error.DefaultWebResponseExceptionTranslator;
import org.springframework.security.oauth2.provider.error.WebResponseExceptionTranslator;
import org.springframework.security.oauth2.provider.expression.OAuth2ExpressionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class TokenRevocationEndpoint {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private WebResponseExceptionTranslator exceptionTranslator = new DefaultWebResponseExceptionTranslator();
    private final ScimUserProvisioning userProvisioning;
    private final MultitenantJdbcClientDetailsService clientDetailsService;
    private final RandomValueStringGenerator generator = new RandomValueStringGenerator(8);
    private final RevocableTokenProvisioning tokenProvisioning;

    public TokenRevocationEndpoint(MultitenantJdbcClientDetailsService clientDetailsService, ScimUserProvisioning userProvisioning, RevocableTokenProvisioning tokenProvisioning) {
        this.clientDetailsService = clientDetailsService;
        this.userProvisioning = userProvisioning;
        this.tokenProvisioning = tokenProvisioning;
    }

    @RequestMapping(value={"/oauth/token/revoke/user/{userId}"})
    public ResponseEntity<Void> revokeTokensForUser(@PathVariable String userId) {
        this.logger.debug((Object)("Revoking tokens for user: " + userId));
        ScimUser user = (ScimUser)this.userProvisioning.retrieve(userId, IdentityZoneHolder.get().getId());
        user.setSalt(this.generator.generate());
        this.userProvisioning.update(userId, user, IdentityZoneHolder.get().getId());
        this.logger.debug((Object)("Tokens revoked for user: " + userId));
        return new ResponseEntity(HttpStatus.OK);
    }

    @RequestMapping(value={"/oauth/token/revoke/user/{userId}/client/{clientId}"})
    public ResponseEntity<Void> revokeTokensForUserAndClient(@PathVariable String userId, @PathVariable String clientId) {
        String zoneId = IdentityZoneHolder.get().getId();
        this.logger.debug((Object)("Revoking tokens for user " + userId + " and client " + clientId));
        List<RevocableToken> tokens = this.tokenProvisioning.getUserTokens(userId, clientId, zoneId);
        for (RevocableToken token : tokens) {
            this.tokenProvisioning.delete(token.getTokenId(), -1, zoneId);
        }
        this.logger.debug((Object)("Tokens revoked for user " + userId + " and client " + clientId));
        return new ResponseEntity(HttpStatus.OK);
    }

    @RequestMapping(value={"/oauth/token/revoke/client/{clientId}"})
    public ResponseEntity<Void> revokeTokensForClient(@PathVariable String clientId) {
        this.logger.debug((Object)("Revoking tokens for client: " + clientId));
        String zoneId = IdentityZoneHolder.get().getId();
        BaseClientDetails client = (BaseClientDetails)this.clientDetailsService.loadClientByClientId(clientId, zoneId);
        client.addAdditionalInformation("token_salt", (Object)this.generator.generate());
        this.clientDetailsService.updateClientDetails((ClientDetails)client, zoneId);
        this.logger.debug((Object)("Tokens revoked for client: " + clientId));
        ((SystemDeletable)((Object)this.tokenProvisioning)).deleteByClient(clientId, zoneId);
        return new ResponseEntity(HttpStatus.OK);
    }

    @RequestMapping(value={"/oauth/token/revoke/{tokenId}"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> revokeTokenById(@PathVariable String tokenId) {
        this.logger.debug((Object)("Revoking token with ID:" + tokenId));
        this.tokenProvisioning.delete(tokenId, -1, IdentityZoneHolder.get().getId());
        this.logger.debug((Object)("Revoked token with ID: " + tokenId));
        return new ResponseEntity(HttpStatus.OK);
    }

    @RequestMapping(value={"/oauth/token/list"}, method={RequestMethod.GET})
    public ResponseEntity<List<RevocableToken>> listUserTokens(OAuth2Authentication authentication) {
        UaaPrincipal principal = (UaaPrincipal)authentication.getUserAuthentication().getPrincipal();
        String userId = principal.getId();
        String clientId = authentication.getOAuth2Request().getClientId();
        this.logger.debug((Object)("Listing revocable tokens access token userId:" + userId + " clientId:" + clientId));
        List<RevocableToken> result = this.tokenProvisioning.getUserTokens(userId, clientId, IdentityZoneHolder.get().getId());
        this.removeTokenValues(result);
        return new ResponseEntity(result, HttpStatus.OK);
    }

    protected void removeTokenValues(List<RevocableToken> result) {
        result.stream().forEach(t -> t.setValue(null));
    }

    @RequestMapping(value={"/oauth/token/list/user/{userId}"}, method={RequestMethod.GET})
    public ResponseEntity<List<RevocableToken>> listUserTokens(@PathVariable String userId, OAuth2Authentication authentication) {
        if (OAuth2ExpressionUtils.hasAnyScope((Authentication)authentication, (String[])new String[]{"tokens.list", "uaa.admin"})) {
            this.logger.debug((Object)("Listing revocable tokens for user:" + userId));
            List<RevocableToken> result = this.tokenProvisioning.getUserTokens(userId, IdentityZoneHolder.get().getId());
            this.removeTokenValues(result);
            return new ResponseEntity(result, HttpStatus.OK);
        }
        return this.listUserTokens(authentication);
    }

    @RequestMapping(value={"/oauth/token/list/client/{clientId}"}, method={RequestMethod.GET})
    public ResponseEntity<List<RevocableToken>> listClientTokens(@PathVariable String clientId, OAuth2Authentication authentication) {
        if (OAuth2ExpressionUtils.hasAnyScope((Authentication)authentication, (String[])new String[]{"tokens.list", "uaa.admin"})) {
            this.logger.debug((Object)("Listing revocable tokens for client:" + clientId));
            List<RevocableToken> result = this.tokenProvisioning.getClientTokens(clientId, IdentityZoneHolder.get().getId());
            this.removeTokenValues(result);
            return new ResponseEntity(result, HttpStatus.OK);
        }
        return this.listUserTokens(authentication);
    }

    @ExceptionHandler(value={ScimResourceNotFoundException.class, NoSuchClientException.class, EmptyResultDataAccessException.class})
    public ResponseEntity<OAuth2Exception> handleException(Exception e) throws Exception {
        this.logger.info((Object)("Handling error: " + e.getClass().getSimpleName() + ", " + e.getMessage()));
        InvalidTokenException e404 = new InvalidTokenException("Resource not found"){

            public int getHttpErrorCode() {
                return 404;
            }
        };
        return this.exceptionTranslator.translate((Exception)((Object)e404));
    }
}

