/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.ldap.extension;

import java.util.Map;
import org.springframework.security.core.GrantedAuthority;

public class LdapAuthority
implements GrantedAuthority {
    private String dn;
    private String role;
    private Map<String, String[]> attributes;

    public String getDn() {
        return this.dn;
    }

    public Map<String, String[]> getAttributes() {
        return this.attributes;
    }

    public LdapAuthority(String role, String dn) {
        this(role, dn, null);
    }

    public LdapAuthority(String role, String dn, Map<String, String[]> attributes) {
        if (role == null) {
            throw new NullPointerException("role can not be null");
        }
        this.role = role;
        this.dn = dn;
        this.attributes = attributes;
    }

    public String[] getAttributeValues(String name) {
        String[] result = null;
        if (this.attributes != null) {
            result = this.attributes.get(name);
        }
        if (result == null) {
            result = new String[]{};
        }
        return result;
    }

    public String getFirstAttributeValue(String name) {
        String[] result = this.getAttributeValues(name);
        if (result.length > 0) {
            return result[0];
        }
        return null;
    }

    public String getAuthority() {
        return this.role;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LdapAuthority)) {
            return false;
        }
        LdapAuthority that = (LdapAuthority)o;
        if (!this.dn.equals(that.dn)) {
            return false;
        }
        return !(this.role != null ? !this.role.equals(that.role) : that.role != null);
    }

    public int hashCode() {
        int result = this.dn.hashCode();
        result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
        return result;
    }
}

