/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.zone.event;

import java.security.Principal;
import org.cloudfoundry.identity.uaa.audit.AuditEvent;
import org.cloudfoundry.identity.uaa.audit.AuditEventType;
import org.cloudfoundry.identity.uaa.audit.event.AbstractUaaEvent;
import org.cloudfoundry.identity.uaa.provider.saml.idp.SamlServiceProvider;
import org.springframework.security.core.Authentication;

public class ServiceProviderModifiedEvent
extends AbstractUaaEvent {
    private static final long serialVersionUID = -204120790766086570L;
    private AuditEventType eventType;
    protected static final String dataFormat = "id=%s; name=%s; entityID=%s";

    public ServiceProviderModifiedEvent(SamlServiceProvider serviceProvider, Authentication authentication, AuditEventType type) {
        super(serviceProvider, authentication);
        this.eventType = type;
    }

    @Override
    public AuditEvent getAuditEvent() {
        SamlServiceProvider provider = (SamlServiceProvider)this.source;
        return this.createAuditRecord(this.getSource().toString(), this.eventType, this.getOrigin((Principal)this.getAuthentication()), String.format(dataFormat, provider.getId(), provider.getName(), provider.getEntityId()));
    }

    public static ServiceProviderModifiedEvent serviceProviderCreated(SamlServiceProvider serviceProvider) {
        return new ServiceProviderModifiedEvent(serviceProvider, ServiceProviderModifiedEvent.getContextAuthentication(), AuditEventType.ServiceProviderCreatedEvent);
    }

    public static ServiceProviderModifiedEvent serviceProviderModified(SamlServiceProvider serviceProvider) {
        return new ServiceProviderModifiedEvent(serviceProvider, ServiceProviderModifiedEvent.getContextAuthentication(), AuditEventType.ServiceProviderModifiedEvent);
    }
}

