/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.login;

import com.google.zxing.WriterException;
import com.warrenstrange.googleauth.GoogleAuthenticatorException;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthentication;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;
import org.cloudfoundry.identity.uaa.mfa.GoogleAuthenticatorAdapter;
import org.cloudfoundry.identity.uaa.mfa.MfaProvider;
import org.cloudfoundry.identity.uaa.mfa.MfaProviderProvisioning;
import org.cloudfoundry.identity.uaa.mfa.UserGoogleMfaCredentialsProvisioning;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class TotpEndpoint {
    public static final String MFA_VALIDATE_USER = "MFA_VALIDATE_USER";
    private UserGoogleMfaCredentialsProvisioning userGoogleMfaCredentialsProvisioning;
    private MfaProviderProvisioning mfaProviderProvisioning;
    private Log logger = LogFactory.getLog(TotpEndpoint.class);
    private GoogleAuthenticatorAdapter googleAuthenticatorService;
    private SavedRequestAwareAuthenticationSuccessHandler redirectingHandler;

    @RequestMapping(value={"/login/mfa/register"}, method={RequestMethod.GET})
    public String generateQrUrl(HttpSession session, Model model) throws NoSuchAlgorithmException, WriterException, IOException, UaaPrincipalIsNotInSession {
        UaaPrincipal uaaPrincipal = this.getSessionAuthPrincipal(session);
        String providerName = IdentityZoneHolder.get().getConfig().getMfaConfig().getProviderName();
        MfaProvider provider = this.mfaProviderProvisioning.retrieveByName(providerName, IdentityZoneHolder.get().getId());
        if (this.userGoogleMfaCredentialsProvisioning.activeUserCredentialExists(uaaPrincipal.getId(), provider.getId())) {
            return "redirect:/login/mfa/verify";
        }
        String url = this.googleAuthenticatorService.getOtpAuthURL(provider.getConfig().getIssuer(), uaaPrincipal.getId(), uaaPrincipal.getName());
        model.addAttribute("qrurl", (Object)url);
        model.addAttribute("identity_zone", (Object)IdentityZoneHolder.get().getName());
        return "mfa/qr_code";
    }

    @RequestMapping(value={"/login/mfa/verify"}, method={RequestMethod.GET})
    public ModelAndView totpAuthorize(HttpSession session, Model model) throws UaaPrincipalIsNotInSession {
        UaaPrincipal uaaPrincipal = this.getSessionAuthPrincipal(session);
        return this.renderEnterCodePage(model, uaaPrincipal);
    }

    @RequestMapping(value={"/login/mfa/verify.do"}, method={RequestMethod.POST})
    public ModelAndView validateCode(Model model, HttpSession session, HttpServletRequest request, HttpServletResponse response, @RequestParam(value="code") String code) throws NoSuchAlgorithmException, IOException, UaaPrincipalIsNotInSession {
        UaaAuthentication sessionAuth = session.getAttribute(MFA_VALIDATE_USER) instanceof UaaAuthentication ? (UaaAuthentication)session.getAttribute(MFA_VALIDATE_USER) : null;
        UaaPrincipal uaaPrincipal = this.getSessionAuthPrincipal(session);
        try {
            Integer codeValue = Integer.valueOf(code);
            if (this.googleAuthenticatorService.isValidCode(uaaPrincipal.getId(), codeValue)) {
                this.userGoogleMfaCredentialsProvisioning.persistCredentials();
                session.removeAttribute(MFA_VALIDATE_USER);
                HashSet<String> authMethods = new HashSet<String>(sessionAuth.getAuthenticationMethods());
                authMethods.addAll(Arrays.asList("otp", "mfa"));
                sessionAuth.setAuthenticationMethods(authMethods);
                SecurityContextHolder.getContext().setAuthentication((Authentication)sessionAuth);
                this.redirectingHandler.onAuthenticationSuccess(request, response, (Authentication)sessionAuth);
                return new ModelAndView("home", Collections.emptyMap());
            }
            this.logger.debug((Object)("Code authorization failed for user: " + uaaPrincipal.getId()));
            model.addAttribute("error", (Object)"Incorrect code, please try again.");
        }
        catch (GoogleAuthenticatorException | NumberFormatException e) {
            this.logger.debug((Object)("Error validating the code for user: " + uaaPrincipal.getId() + ". Error: " + e.getMessage()));
            model.addAttribute("error", (Object)"Incorrect code, please try again.");
        }
        catch (ServletException e) {
            this.logger.debug((Object)("Error redirecting user: " + uaaPrincipal.getId() + ". Error: " + e.getMessage()));
            model.addAttribute("error", (Object)"Can't redirect user");
        }
        return this.renderEnterCodePage(model, uaaPrincipal);
    }

    public void setUserGoogleMfaCredentialsProvisioning(UserGoogleMfaCredentialsProvisioning userGoogleMfaCredentialsProvisioning) {
        this.userGoogleMfaCredentialsProvisioning = userGoogleMfaCredentialsProvisioning;
    }

    public void setMfaProviderProvisioning(MfaProviderProvisioning mfaProviderProvisioning) {
        this.mfaProviderProvisioning = mfaProviderProvisioning;
    }

    public void setGoogleAuthenticatorService(GoogleAuthenticatorAdapter googleAuthenticatorService) {
        this.googleAuthenticatorService = googleAuthenticatorService;
    }

    @ExceptionHandler(value={UaaPrincipalIsNotInSession.class})
    public ModelAndView handleUaaPrincipalIsNotInSession() {
        return new ModelAndView("redirect:/login", Collections.emptyMap());
    }

    private ModelAndView renderEnterCodePage(Model model, UaaPrincipal uaaPrincipal) {
        model.addAttribute("is_first_time_user", (Object)this.userGoogleMfaCredentialsProvisioning.isFirstTimeMFAUser(uaaPrincipal));
        model.addAttribute("identity_zone", (Object)IdentityZoneHolder.get().getName());
        return new ModelAndView("mfa/enter_code", model.asMap());
    }

    private UaaPrincipal getSessionAuthPrincipal(HttpSession session) throws UaaPrincipalIsNotInSession {
        UaaPrincipal principal;
        UaaAuthentication sessionAuth;
        UaaAuthentication uaaAuthentication = sessionAuth = session.getAttribute(MFA_VALIDATE_USER) instanceof UaaAuthentication ? (UaaAuthentication)session.getAttribute(MFA_VALIDATE_USER) : null;
        if (sessionAuth != null && (principal = sessionAuth.getPrincipal()) != null) {
            return principal;
        }
        throw new UaaPrincipalIsNotInSession();
    }

    public void setRedirectingHandler(SavedRequestAwareAuthenticationSuccessHandler handler) {
        this.redirectingHandler = handler;
    }

    public class UaaPrincipalIsNotInSession
    extends Exception {
    }
}

