/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.mfa;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.warrenstrange.googleauth.GoogleAuthenticatorKey;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import javax.imageio.ImageIO;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriUtils;

public class MfaRegisterQRGenerator {
    private static final String OTPAUTH_TOTP_URI = "otpauth://totp/%s:%s?secret=%s&issuer=%s";
    private static final String STRING_ENCODING = "UTF-8";

    public static String getQRCode(String issuer, String accountName, GoogleAuthenticatorKey credentials) throws WriterException, IOException {
        if (!StringUtils.hasText((String)issuer) || issuer.contains(":")) {
            throw new IllegalArgumentException("invalid issuer");
        }
        if (!StringUtils.hasText((String)accountName) || accountName.contains(":")) {
            throw new IllegalArgumentException("invalid account name");
        }
        QRCodeWriter writer = new QRCodeWriter();
        BitMatrix qrBitMatrix = writer.encode(String.format(OTPAUTH_TOTP_URI, UriUtils.encode((String)issuer, (String)STRING_ENCODING), UriUtils.encode((String)accountName, (String)STRING_ENCODING), credentials.getKey(), UriUtils.encode((String)issuer, (String)STRING_ENCODING)), BarcodeFormat.QR_CODE, 200, 200);
        BufferedImage qrImage = MatrixToImageWriter.toBufferedImage((BitMatrix)qrBitMatrix);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)qrImage, "png", os);
        return Base64.getEncoder().encodeToString(os.toByteArray());
    }

    public static String getQRCodePngDataUri(String issuer, String accountName, GoogleAuthenticatorKey credentials) throws WriterException, IOException {
        return "data:image/png;base64," + MfaRegisterQRGenerator.getQRCode(issuer, accountName, credentials);
    }
}

