/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.saml;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.cloudfoundry.identity.uaa.provider.SamlIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.saml.SamlIdentityProviderConfigurator;
import org.cloudfoundry.identity.uaa.provider.saml.ZoneAwareMetadataGenerator;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.joda.time.DateTime;
import org.opensaml.saml2.common.Extensions;
import org.opensaml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml2.metadata.provider.MetadataFilter;
import org.opensaml.saml2.metadata.provider.MetadataFilterChain;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.saml2.metadata.provider.SignatureValidationFilter;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.Namespace;
import org.opensaml.xml.NamespaceManager;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.schema.XSBooleanValue;
import org.opensaml.xml.security.x509.BasicPKIXValidationInformation;
import org.opensaml.xml.security.x509.BasicX509CredentialNameEvaluator;
import org.opensaml.xml.security.x509.CertPathPKIXValidationOptions;
import org.opensaml.xml.security.x509.PKIXTrustEvaluator;
import org.opensaml.xml.security.x509.PKIXValidationInformationResolver;
import org.opensaml.xml.security.x509.PKIXValidationOptions;
import org.opensaml.xml.security.x509.StaticPKIXValidationInformationResolver;
import org.opensaml.xml.security.x509.X509CredentialNameEvaluator;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.SignatureTrustEngine;
import org.opensaml.xml.signature.impl.PKIXSignatureTrustEngine;
import org.opensaml.xml.util.IDIndex;
import org.opensaml.xml.util.LazySet;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.saml.key.KeyManager;
import org.springframework.security.saml.metadata.ExtendedMetadata;
import org.springframework.security.saml.metadata.ExtendedMetadataDelegate;
import org.springframework.security.saml.metadata.ExtendedMetadataProvider;
import org.springframework.security.saml.metadata.MetadataManager;
import org.springframework.security.saml.metadata.MetadataMemoryProvider;
import org.springframework.security.saml.trust.AllowAllSignatureTrustEngine;
import org.springframework.security.saml.trust.CertPathPKIXTrustEvaluator;
import org.springframework.security.saml.trust.httpclient.TLSProtocolConfigurer;
import org.springframework.security.saml.util.SAMLUtil;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class NonSnarlMetadataManager
extends MetadataManager
implements ExtendedMetadataProvider,
InitializingBean,
DisposableBean {
    protected final Logger log = LoggerFactory.getLogger(NonSnarlMetadataManager.class);
    private ExtendedMetadata defaultExtendedMetadata;
    protected KeyManager keyManager;
    private final SamlIdentityProviderConfigurator configurator;
    private ZoneAwareMetadataGenerator generator;

    public NonSnarlMetadataManager(SamlIdentityProviderConfigurator configurator) throws MetadataProviderException {
        super(Collections.EMPTY_LIST);
        this.configurator = configurator;
        this.defaultExtendedMetadata = new ExtendedMetadata();
        super.setRefreshCheckInterval(0L);
    }

    public void destroy() {
    }

    public void setProviders(List<MetadataProvider> newProviders) throws MetadataProviderException {
    }

    public void refreshMetadata() {
    }

    public ExtendedMetadataDelegate getLocalServiceProvider() throws MetadataProviderException {
        EntityDescriptor descriptor = this.generator.generateMetadata();
        ExtendedMetadata extendedMetadata = this.generator.generateExtendedMetadata();
        this.log.info("Initialized local service provider for entityID: " + descriptor.getEntityID());
        MetadataMemoryProvider memoryProvider = new MetadataMemoryProvider(descriptor);
        memoryProvider.initialize();
        return new ExtendedMetadataDelegate((MetadataProvider)memoryProvider, extendedMetadata);
    }

    public void addMetadataProvider(MetadataProvider newProvider) throws MetadataProviderException {
    }

    public void removeMetadataProvider(MetadataProvider provider) {
    }

    public List<MetadataProvider> getProviders() {
        ArrayList<MetadataProvider> result = new ArrayList<MetadataProvider>();
        for (ExtendedMetadataDelegate delegate : this.getAvailableProviders()) {
            result.add((MetadataProvider)delegate);
        }
        return result;
    }

    public List<ExtendedMetadataDelegate> getAvailableProviders() {
        IdentityZone zone = IdentityZoneHolder.get();
        ArrayList<ExtendedMetadataDelegate> result = new ArrayList<ExtendedMetadataDelegate>();
        try {
            result.add(this.getLocalServiceProvider());
        }
        catch (MetadataProviderException e) {
            throw new IllegalStateException(e);
        }
        for (SamlIdentityProviderDefinition definition : this.configurator.getIdentityProviderDefinitions()) {
            this.log.info("Adding SAML IDP zone[" + zone.getId() + "] alias[" + definition.getIdpEntityAlias() + "]");
            try {
                ExtendedMetadataDelegate delegate = this.configurator.getExtendedMetadataDelegate(definition);
                this.initializeProvider(delegate);
                this.initializeProviderData(delegate);
                this.initializeProviderFilters(delegate);
                result.add(delegate);
            }
            catch (MetadataProviderException e) {
                this.log.error("Invalid SAML IDP zone[" + zone.getId() + "] alias[" + definition.getIdpEntityAlias() + "]", (Throwable)e);
            }
        }
        return result;
    }

    protected void initializeProvider(ExtendedMetadataDelegate provider) throws MetadataProviderException {
        this.log.debug("Initializing extendedMetadataDelegate {}", (Object)provider);
        provider.initialize();
    }

    protected String getProviderIdpAlias(ExtendedMetadataDelegate provider) throws MetadataProviderException {
        List<String> stringSet = this.parseProvider((MetadataProvider)provider);
        for (String key : stringSet) {
            RoleDescriptor idpRoleDescriptor = provider.getRole(key, IDPSSODescriptor.DEFAULT_ELEMENT_NAME, "urn:oasis:names:tc:SAML:2.0:protocol");
            if (idpRoleDescriptor == null) continue;
            return key;
        }
        return null;
    }

    protected String getProviderSpAlias(ExtendedMetadataDelegate provider) throws MetadataProviderException {
        List<String> stringSet = this.parseProvider((MetadataProvider)provider);
        for (String key : stringSet) {
            RoleDescriptor spRoleDescriptor = provider.getRole(key, SPSSODescriptor.DEFAULT_ELEMENT_NAME, "urn:oasis:names:tc:SAML:2.0:protocol");
            if (spRoleDescriptor == null) continue;
            return key;
        }
        return null;
    }

    protected String getHostedSpName(ExtendedMetadataDelegate provider) throws MetadataProviderException {
        List<String> stringSet = this.parseProvider((MetadataProvider)provider);
        for (String key : stringSet) {
            ExtendedMetadata extendedMetadata;
            RoleDescriptor spRoleDescriptor = provider.getRole(key, SPSSODescriptor.DEFAULT_ELEMENT_NAME, "urn:oasis:names:tc:SAML:2.0:protocol");
            if (spRoleDescriptor == null || (extendedMetadata = this.getExtendedMetadata(key, (MetadataProvider)provider)) == null || !extendedMetadata.isLocal()) continue;
            return key;
        }
        return null;
    }

    protected String getProviderAlias(ExtendedMetadataDelegate provider) throws MetadataProviderException {
        List<String> stringSet = this.parseProvider((MetadataProvider)provider);
        for (String key : stringSet) {
            ExtendedMetadata extendedMetadata = this.getExtendedMetadata(key, (MetadataProvider)provider);
            if (extendedMetadata != null) {
                if (extendedMetadata.isLocal()) {
                    String alias = extendedMetadata.getAlias();
                    if (alias != null) {
                        SAMLUtil.verifyAlias((String)alias, (String)key);
                        return alias;
                    }
                    this.log.debug("Local entity {} doesn't have an alias", (Object)key);
                    continue;
                }
                this.log.debug("Remote entity {} available", (Object)key);
                continue;
            }
            this.log.debug("No extended metadata available for entity {}", (Object)key);
        }
        return null;
    }

    protected void initializeProviderData(ExtendedMetadataDelegate provider) throws MetadataProviderException {
    }

    protected void initializeProviderFilters(ExtendedMetadataDelegate provider) throws MetadataProviderException {
        boolean requireSignature = provider.isMetadataRequireSignature();
        SignatureTrustEngine trustEngine = this.getTrustEngine((MetadataProvider)provider);
        SignatureValidationFilter filter = new SignatureValidationFilter(trustEngine);
        filter.setRequireSignature(requireSignature);
        this.log.debug("Created new trust manager for metadata provider {}", (Object)provider);
        MetadataFilter currentFilter = provider.getMetadataFilter();
        if (currentFilter != null) {
            if (currentFilter instanceof MetadataFilterChain) {
                this.log.debug("Adding signature filter into existing chain");
                MetadataFilterChain chain = (MetadataFilterChain)currentFilter;
                chain.getFilters().add(filter);
            } else {
                this.log.debug("Combining signature filter with the existing in a new chain");
                MetadataFilterChain chain = new MetadataFilterChain();
                chain.getFilters().add(currentFilter);
                chain.getFilters().add(filter);
            }
        } else {
            this.log.debug("Adding signature filter");
            provider.setMetadataFilter((MetadataFilter)filter);
        }
    }

    protected SignatureTrustEngine getTrustEngine(MetadataProvider provider) {
        Set trustedKeys = null;
        boolean verifyTrust = true;
        boolean forceRevocationCheck = false;
        if (provider instanceof ExtendedMetadataDelegate) {
            ExtendedMetadataDelegate metadata = (ExtendedMetadataDelegate)provider;
            trustedKeys = metadata.getMetadataTrustedKeys();
            verifyTrust = metadata.isMetadataTrustCheck();
            forceRevocationCheck = metadata.isForceMetadataRevocationCheck();
        }
        if (verifyTrust) {
            this.log.debug("Setting trust verification for metadata provider {}", (Object)provider);
            CertPathPKIXValidationOptions pkixOptions = new CertPathPKIXValidationOptions();
            if (forceRevocationCheck) {
                this.log.debug("Revocation checking forced to true");
                pkixOptions.setForceRevocationEnabled(true);
            } else {
                this.log.debug("Revocation checking not forced");
                pkixOptions.setForceRevocationEnabled(false);
            }
            return new PKIXSignatureTrustEngine(this.getPKIXResolver(provider, trustedKeys, null), Configuration.getGlobalSecurityConfiguration().getDefaultKeyInfoCredentialResolver(), (PKIXTrustEvaluator)new CertPathPKIXTrustEvaluator((PKIXValidationOptions)pkixOptions), (X509CredentialNameEvaluator)new BasicX509CredentialNameEvaluator());
        }
        this.log.debug("Trust verification skipped for metadata provider {}", (Object)provider);
        return new AllowAllSignatureTrustEngine(Configuration.getGlobalSecurityConfiguration().getDefaultKeyInfoCredentialResolver());
    }

    protected PKIXValidationInformationResolver getPKIXResolver(MetadataProvider provider, Set<String> trustedKeys, Set<String> trustedNames) {
        if (trustedKeys == null) {
            trustedKeys = this.keyManager.getAvailableCredentials();
        }
        LinkedList<X509Certificate> certificates = new LinkedList<X509Certificate>();
        for (String key : trustedKeys) {
            this.log.debug("Adding PKIX trust anchor {} for metadata verification of provider {}", (Object)key, (Object)provider);
            X509Certificate certificate = this.keyManager.getCertificate(key);
            if (certificate != null) {
                certificates.add(certificate);
                continue;
            }
            this.log.warn("Cannot construct PKIX trust anchor for key with alias {} for provider {}, key isn't included in the keystore", (Object)key, (Object)provider);
        }
        LinkedList<BasicPKIXValidationInformation> info = new LinkedList<BasicPKIXValidationInformation>();
        info.add(new BasicPKIXValidationInformation(certificates, null, Integer.valueOf(4)));
        return new StaticPKIXValidationInformationResolver(info, trustedNames);
    }

    protected List<String> parseProvider(MetadataProvider provider) throws MetadataProviderException {
        LinkedList<String> result = new LinkedList<String>();
        XMLObject object = provider.getMetadata();
        if (object instanceof EntityDescriptor) {
            this.addDescriptor(result, (EntityDescriptor)object);
        } else if (object instanceof EntitiesDescriptor) {
            this.addDescriptors(result, (EntitiesDescriptor)object);
        }
        return result;
    }

    private void addDescriptors(List<String> result, EntitiesDescriptor descriptors) throws MetadataProviderException {
        this.log.debug("Found metadata EntitiesDescriptor with ID", (Object)descriptors.getID());
        if (descriptors.getEntitiesDescriptors() != null) {
            for (EntitiesDescriptor descriptor : descriptors.getEntitiesDescriptors()) {
                this.addDescriptors(result, descriptor);
            }
        }
        if (descriptors.getEntityDescriptors() != null) {
            for (EntitiesDescriptor descriptor : descriptors.getEntityDescriptors()) {
                this.addDescriptor(result, (EntityDescriptor)descriptor);
            }
        }
    }

    private void addDescriptor(List<String> result, EntityDescriptor descriptor) throws MetadataProviderException {
        String entityID = descriptor.getEntityID();
        this.log.debug("Found metadata EntityDescriptor with ID", (Object)entityID);
        result.add(entityID);
    }

    public Set<String> getIDPEntityNames() {
        HashSet<String> result = new HashSet<String>();
        for (ExtendedMetadataDelegate delegate : this.getAvailableProviders()) {
            try {
                String idp = this.getProviderIdpAlias(delegate);
                if (!StringUtils.hasText((String)idp)) continue;
                result.add(idp);
            }
            catch (MetadataProviderException e) {
                this.log.error("Unable to get IDP alias for:" + delegate, (Throwable)e);
            }
        }
        return result;
    }

    public Set<String> getSPEntityNames() {
        HashSet<String> result = new HashSet<String>();
        for (ExtendedMetadataDelegate delegate : this.getAvailableProviders()) {
            try {
                String sp = this.getHostedSpName(delegate);
                if (!StringUtils.hasText((String)sp)) continue;
                result.add(sp);
            }
            catch (MetadataProviderException e) {
                this.log.error("Unable to get IDP alias for:" + delegate, (Throwable)e);
            }
        }
        return result;
    }

    public boolean isIDPValid(String idpID) {
        return this.getIDPEntityNames().contains(idpID);
    }

    public boolean isSPValid(String spID) {
        return this.getIDPEntityNames().contains(spID);
    }

    public String getHostedSPName() {
        for (ExtendedMetadataDelegate delegate : this.getAvailableProviders()) {
            try {
                String spName = this.getHostedSpName(delegate);
                if (!StringUtils.hasText((String)spName)) continue;
                return spName;
            }
            catch (MetadataProviderException e) {
                this.log.error("Unable to find hosted SP name:" + delegate, (Throwable)e);
            }
        }
        return null;
    }

    public void setHostedSPName(String hostedSPName) {
    }

    public String getDefaultIDP() throws MetadataProviderException {
        Iterator<String> iterator = this.getIDPEntityNames().iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        throw new MetadataProviderException("No IDP was configured, please update included metadata with at least one IDP");
    }

    public void setDefaultIDP(String defaultIDP) {
    }

    public ExtendedMetadata getExtendedMetadata(String entityID) throws MetadataProviderException {
        for (MetadataProvider provider : this.getProviders()) {
            ExtendedMetadata extendedMetadata = this.getExtendedMetadata(entityID, provider);
            if (extendedMetadata == null) continue;
            return extendedMetadata;
        }
        return this.getDefaultExtendedMetadata().clone();
    }

    private ExtendedMetadata getExtendedMetadata(String entityID, MetadataProvider provider) throws MetadataProviderException {
        ExtendedMetadataProvider extendedProvider;
        ExtendedMetadata extendedMetadata;
        if (provider instanceof ExtendedMetadataProvider && (extendedMetadata = (extendedProvider = (ExtendedMetadataProvider)provider).getExtendedMetadata(entityID)) != null) {
            return extendedMetadata.clone();
        }
        return null;
    }

    public EntityDescriptor getEntityDescriptor(byte[] hash) throws MetadataProviderException {
        for (String idp : this.getIDPEntityNames()) {
            if (!SAMLUtil.compare((byte[])hash, (String)idp)) continue;
            return this.getEntityDescriptor(idp);
        }
        for (String sp : this.getSPEntityNames()) {
            if (!SAMLUtil.compare((byte[])hash, (String)sp)) continue;
            return this.getEntityDescriptor(sp);
        }
        return null;
    }

    public String getEntityIdForAlias(String entityAlias) throws MetadataProviderException {
        ExtendedMetadata extendedMetadata;
        if (entityAlias == null) {
            return null;
        }
        String entityId = null;
        for (String idp : this.getIDPEntityNames()) {
            extendedMetadata = this.getExtendedMetadata(idp);
            if (!extendedMetadata.isLocal() || !entityAlias.equals(extendedMetadata.getAlias())) continue;
            if (entityId != null && !entityId.equals(idp)) {
                throw new MetadataProviderException("Alias " + entityAlias + " is used both for entity " + entityId + " and " + idp);
            }
            entityId = idp;
        }
        for (String sp : this.getSPEntityNames()) {
            extendedMetadata = this.getExtendedMetadata(sp);
            if (!extendedMetadata.isLocal() || !entityAlias.equals(extendedMetadata.getAlias())) continue;
            if (entityId != null && !entityId.equals(sp)) {
                throw new MetadataProviderException("Alias " + entityAlias + " is used both for entity " + entityId + " and " + sp);
            }
            entityId = sp;
        }
        return entityId;
    }

    public ExtendedMetadata getDefaultExtendedMetadata() {
        return this.defaultExtendedMetadata;
    }

    public void setDefaultExtendedMetadata(ExtendedMetadata defaultExtendedMetadata) {
        this.defaultExtendedMetadata = defaultExtendedMetadata;
    }

    public boolean isRefreshRequired() {
        return false;
    }

    public void setRefreshRequired(boolean refreshRequired) {
    }

    public void setRefreshCheckInterval(long refreshCheckInterval) {
        super.setRefreshCheckInterval(0L);
    }

    public void setKeyManager(KeyManager keyManager) {
        this.keyManager = keyManager;
        super.setKeyManager(keyManager);
    }

    @Autowired(required=false)
    public void setTLSConfigurer(TLSProtocolConfigurer configurer) {
    }

    public EntitiesDescriptor getEntitiesDescriptor(String name) throws MetadataProviderException {
        EntitiesDescriptor descriptor = null;
        for (MetadataProvider provider : this.getProviders()) {
            this.log.debug("Checking child metadata provider for entities descriptor with name: {}", (Object)name);
            try {
                descriptor = provider.getEntitiesDescriptor(name);
                if (descriptor == null) continue;
                break;
            }
            catch (MetadataProviderException e) {
                this.log.warn("Error retrieving metadata from provider of type {}, proceeding to next provider", (Object)provider.getClass().getName(), (Object)e);
            }
        }
        return descriptor;
    }

    public EntityDescriptor getEntityDescriptor(String entityID) throws MetadataProviderException {
        EntityDescriptor descriptor = null;
        for (MetadataProvider provider : this.getProviders()) {
            this.log.debug("Checking child metadata provider for entity descriptor with entity ID: {}", (Object)entityID);
            try {
                descriptor = provider.getEntityDescriptor(entityID);
                if (descriptor == null) continue;
                break;
            }
            catch (MetadataProviderException e) {
                this.log.warn("Error retrieving metadata from provider of type {}, proceeding to next provider", (Object)provider.getClass().getName(), (Object)e);
            }
        }
        return descriptor;
    }

    public List<RoleDescriptor> getRole(String entityID, QName roleName) throws MetadataProviderException {
        List roleDescriptors = null;
        for (MetadataProvider provider : this.getProviders()) {
            this.log.debug("Checking child metadata provider for entity descriptor with entity ID: {}", (Object)entityID);
            try {
                roleDescriptors = provider.getRole(entityID, roleName);
                if (roleDescriptors == null || roleDescriptors.isEmpty()) continue;
                break;
            }
            catch (MetadataProviderException e) {
                this.log.warn("Error retrieving metadata from provider of type {}, proceeding to next provider", (Object)provider.getClass().getName(), (Object)e);
            }
        }
        return roleDescriptors;
    }

    public RoleDescriptor getRole(String entityID, QName roleName, String supportedProtocol) throws MetadataProviderException {
        RoleDescriptor roleDescriptor = null;
        for (MetadataProvider provider : this.getProviders()) {
            this.log.debug("Checking child metadata provider for entity descriptor with entity ID: {}", (Object)entityID);
            try {
                roleDescriptor = provider.getRole(entityID, roleName, supportedProtocol);
                if (roleDescriptor == null) continue;
                break;
            }
            catch (MetadataProviderException e) {
                this.log.warn("Error retrieving metadata from provider of type {}, proceeding to next provider", (Object)provider.getClass().getName(), (Object)e);
            }
        }
        return roleDescriptor;
    }

    public XMLObject getMetadata() throws MetadataProviderException {
        return new ChainingEntitiesDescriptor();
    }

    public void setMetadataGenerator(ZoneAwareMetadataGenerator generator) throws BeansException {
        this.generator = generator;
    }

    public class ChainingEntitiesDescriptor
    implements EntitiesDescriptor {
        private ArrayList<XMLObject> childDescriptors = new ArrayList();

        public ChainingEntitiesDescriptor() throws MetadataProviderException {
            for (MetadataProvider provider : NonSnarlMetadataManager.this.getProviders()) {
                this.childDescriptors.add(provider.getMetadata());
            }
        }

        public List<EntitiesDescriptor> getEntitiesDescriptors() {
            ArrayList<EntitiesDescriptor> descriptors = new ArrayList<EntitiesDescriptor>();
            for (XMLObject descriptor : this.childDescriptors) {
                if (!(descriptor instanceof EntitiesDescriptor)) continue;
                descriptors.add((EntitiesDescriptor)descriptor);
            }
            return descriptors;
        }

        public List<EntityDescriptor> getEntityDescriptors() {
            ArrayList<EntityDescriptor> descriptors = new ArrayList<EntityDescriptor>();
            for (XMLObject descriptor : this.childDescriptors) {
                if (!(descriptor instanceof EntityDescriptor)) continue;
                descriptors.add((EntityDescriptor)descriptor);
            }
            return descriptors;
        }

        public Extensions getExtensions() {
            return null;
        }

        public String getID() {
            return null;
        }

        public String getName() {
            return null;
        }

        public void setExtensions(Extensions extensions) {
        }

        public void setID(String newID) {
        }

        public void setName(String name) {
        }

        public String getSignatureReferenceID() {
            return null;
        }

        public Signature getSignature() {
            return null;
        }

        public boolean isSigned() {
            return false;
        }

        public void setSignature(Signature newSignature) {
        }

        public void addNamespace(Namespace namespace) {
        }

        public void detach() {
        }

        public Element getDOM() {
            return null;
        }

        public QName getElementQName() {
            return EntitiesDescriptor.DEFAULT_ELEMENT_NAME;
        }

        public IDIndex getIDIndex() {
            return null;
        }

        public NamespaceManager getNamespaceManager() {
            return null;
        }

        public Set<Namespace> getNamespaces() {
            return new LazySet();
        }

        public String getNoNamespaceSchemaLocation() {
            return null;
        }

        public List<XMLObject> getOrderedChildren() {
            ArrayList<XMLObject> descriptors = new ArrayList<XMLObject>();
            try {
                for (MetadataProvider provider : NonSnarlMetadataManager.this.getProviders()) {
                    descriptors.add(provider.getMetadata());
                }
            }
            catch (MetadataProviderException e) {
                NonSnarlMetadataManager.this.log.error("Unable to generate list of child descriptors", (Throwable)e);
            }
            return descriptors;
        }

        public XMLObject getParent() {
            return null;
        }

        public String getSchemaLocation() {
            return null;
        }

        public QName getSchemaType() {
            return EntitiesDescriptor.TYPE_NAME;
        }

        public boolean hasChildren() {
            return !this.getOrderedChildren().isEmpty();
        }

        public boolean hasParent() {
            return false;
        }

        public void releaseChildrenDOM(boolean propagateRelease) {
        }

        public void releaseDOM() {
        }

        public void releaseParentDOM(boolean propagateRelease) {
        }

        public void removeNamespace(Namespace namespace) {
        }

        public XMLObject resolveID(String id) {
            return null;
        }

        public XMLObject resolveIDFromRoot(String id) {
            return null;
        }

        public void setDOM(Element dom) {
        }

        public void setNoNamespaceSchemaLocation(String location) {
        }

        public void setParent(XMLObject parent) {
        }

        public void setSchemaLocation(String location) {
        }

        public void deregisterValidator(Validator validator) {
        }

        public List<Validator> getValidators() {
            return new ArrayList<Validator>();
        }

        public void registerValidator(Validator validator) {
        }

        public void validate(boolean validateDescendants) throws ValidationException {
        }

        public DateTime getValidUntil() {
            return null;
        }

        public boolean isValid() {
            return true;
        }

        public void setValidUntil(DateTime validUntil) {
        }

        public Long getCacheDuration() {
            return null;
        }

        public void setCacheDuration(Long duration) {
        }

        public Boolean isNil() {
            return Boolean.FALSE;
        }

        public XSBooleanValue isNilXSBoolean() {
            return new XSBooleanValue(Boolean.FALSE, false);
        }

        public void setNil(Boolean arg0) {
        }

        public void setNil(XSBooleanValue arg0) {
        }
    }
}

