/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.cloudfoundry.identity.uaa.util.TimeService;

public class TimeBasedExpiringValueMap<K, V> {
    public static final long DEFALT_TIMEOUT = 120000L;
    private final TimeService timeService;
    private final Map<K, Value> map;
    private final long timeout;
    private final AtomicLong lastCheck = new AtomicLong(0L);

    public TimeBasedExpiringValueMap(TimeService timeService) {
        this(timeService, 120000L);
    }

    public TimeBasedExpiringValueMap(TimeService timeService, long timeoutMilliseconds) {
        this.timeService = timeService;
        this.map = new ConcurrentHashMap<K, Value>();
        this.timeout = timeoutMilliseconds;
    }

    public void put(K key, V value) {
        Value v = new Value(this.timeService.getCurrentTimeMillis(), key, value);
        this.map.put(key, v);
        this.expireCheck();
    }

    public V get(K key) {
        Value v = this.map.get(key);
        if (v != null) {
            this.removeExpired(v);
            return v.getValue();
        }
        this.expireCheck();
        return null;
    }

    public V remove(K key) {
        Value v = this.map.remove(key);
        if (v != null) {
            return v.getValue();
        }
        return null;
    }

    public int size() {
        return this.map.size();
    }

    public void clear() {
        this.map.clear();
    }

    protected void expireCheck() {
        long l;
        long now = this.timeService.getCurrentTimeMillis();
        if (now - (l = this.lastCheck.get()) > this.timeout && this.lastCheck.compareAndSet(l, now)) {
            Map.Entry[] entries;
            for (Map.Entry entry : entries = this.map.entrySet().toArray(new Map.Entry[0])) {
                this.removeExpired((Value)entry.getValue());
            }
        }
    }

    protected boolean hasExpired(long time) {
        long now = this.timeService.getCurrentTimeMillis();
        return now - time > this.timeout;
    }

    protected boolean removeExpired(Value value) {
        if (this.hasExpired(value.getTime())) {
            Value remove = this.map.remove(value.getKey());
            if (this.hasExpired(remove.getTime())) {
                return true;
            }
            this.map.putIfAbsent(value.getKey(), value);
        }
        return false;
    }

    private class Value {
        final long time;
        final K key;
        final V value;

        private Value(long time, K key, V value) {
            this.time = time;
            this.value = value;
            this.key = key;
        }

        public V getValue() {
            return this.value;
        }

        public K getKey() {
            return this.key;
        }

        public long getTime() {
            return this.time;
        }
    }
}

