/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.db;

import org.cloudfoundry.identity.uaa.db.Vendor;

public class DatabaseUrlModifier {
    private final Vendor databaseType;
    private final String url;
    private int connectTimeoutSeconds = 10;

    public DatabaseUrlModifier(Vendor databaseType, String url) {
        if (databaseType == null) {
            throw new NullPointerException();
        }
        this.databaseType = databaseType;
        this.url = url;
    }

    public int getConnectTimeoutSeconds() {
        return this.connectTimeoutSeconds;
    }

    public void setConnectTimeoutSeconds(int connectTimeoutSeconds) {
        this.connectTimeoutSeconds = connectTimeoutSeconds;
    }

    public Vendor getDatabaseType() {
        return this.databaseType;
    }

    public String getUrl() {
        StringBuilder result = new StringBuilder(this.url);
        switch (this.getDatabaseType()) {
            case mysql: {
                this.appendParameter(result, "connectTimeout", this.getConnectTimeoutSeconds() * 1000);
                break;
            }
            case postgresql: {
                this.appendParameter(result, "connectTimeout", this.getConnectTimeoutSeconds());
                break;
            }
            case sqlserver: {
                this.appendParameter(result, "loginTimeout", this.getConnectTimeoutSeconds());
                break;
            }
            case hsqldb: {
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized database: " + (Object)((Object)this.databaseType));
            }
        }
        return result.toString();
    }

    private void appendParameter(StringBuilder result, String name, Object value) {
        if (result.indexOf("?") > 0) {
            result.append("&");
        } else {
            result.append("?");
        }
        result.append(name);
        result.append("=");
        result.append(value.toString());
    }
}

