/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.audit;

public enum AuditEventType {
    UserAuthenticationSuccess(0),
    UserAuthenticationFailure(1),
    UserNotFound(2),
    PasswordChangeSuccess(3),
    PrincipalAuthenticationSuccess(4),
    PrincipalAuthenticationFailure(5),
    PrincipalNotFound(6),
    PasswordChangeFailure(7),
    SecretChangeSuccess(8),
    SecretChangeFailure(9),
    ClientCreateSuccess(10),
    ClientUpdateSuccess(11),
    ClientDeleteSuccess(12),
    ClientApprovalsDeleted(13),
    ClientAuthenticationSuccess(14),
    ClientAuthenticationFailure(15),
    ApprovalModifiedEvent(16),
    TokenIssuedEvent(17),
    UserCreatedEvent(18),
    UserModifiedEvent(19),
    UserDeletedEvent(20),
    UserVerifiedEvent(21),
    PasswordResetRequest(22),
    GroupCreatedEvent(23),
    GroupModifiedEvent(24),
    GroupDeletedEvent(25),
    EmailChangedEvent(26),
    UnverifiedUserAuthentication(27),
    IdentityProviderCreatedEvent(28),
    IdentityProviderModifiedEvent(29),
    IdentityZoneCreatedEvent(30),
    IdentityZoneModifiedEvent(31),
    EntityDeletedEvent(32),
    ServiceProviderCreatedEvent(33),
    ServiceProviderModifiedEvent(34),
    UserAccountUnlockedEvent(35),
    TokenRevocationEvent(36),
    IdentityProviderAuthenticationSuccess(37),
    PasswordAuthenticationFailure(38),
    MfaAuthenticationSuccess(39),
    MfaAuthenticationFailure(40);

    private final int code;

    private AuditEventType(int code) {
        this.code = code;
    }

    public static AuditEventType fromCode(int code) {
        for (AuditEventType a : AuditEventType.values()) {
            if (a.getCode() != code) continue;
            return a;
        }
        throw new IllegalArgumentException("No event type with code " + code + " exists");
    }

    public int getCode() {
        return this.code;
    }
}

