/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.mfa;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.cloudfoundry.identity.uaa.mfa.AbstractMfaProviderConfig;
import org.cloudfoundry.identity.uaa.mfa.GoogleMfaProviderConfig;
import org.cloudfoundry.identity.uaa.mfa.MfaProvider;
import org.cloudfoundry.identity.uaa.mfa.MfaProviderProvisioning;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.EmptyResultDataAccessException;

public class MfaProviderBootstrap
implements InitializingBean {
    private List<MfaProvider> mfaProviders = new ArrayList<MfaProvider>();
    private MfaProviderProvisioning provisioning;

    public MfaProviderBootstrap(MfaProviderProvisioning provisioning) {
        this.provisioning = provisioning;
    }

    public void afterPropertiesSet() throws Exception {
        for (MfaProvider provider : this.mfaProviders) {
            MfaProvider existing;
            try {
                existing = this.provisioning.retrieveByName(provider.getName(), "uaa");
            }
            catch (EmptyResultDataAccessException x) {
                this.provisioning.create(provider, "uaa");
                continue;
            }
            provider.setId(existing.getId());
            provider.setCreated(existing.getCreated());
            provider.setLastModified(new Date(System.currentTimeMillis()));
            this.provisioning.update(provider, "uaa");
        }
    }

    public List<MfaProvider> getMfaProviders() {
        return this.mfaProviders;
    }

    public void setMfaProviders(Map<String, Map<String, Object>> mfaProviderYaml) {
        this.mfaProviders.clear();
        if (mfaProviderYaml == null) {
            return;
        }
        for (Map.Entry<String, Map<String, Object>> mfaProvider : mfaProviderYaml.entrySet()) {
            String name = mfaProvider.getKey();
            String type = (String)mfaProvider.getValue().get("type");
            MfaProvider def = new MfaProvider();
            def.setType(MfaProvider.MfaProviderType.forValue((String)type));
            def.setName(name);
            def.setIdentityZoneId("uaa");
            if (def.getType() == MfaProvider.MfaProviderType.GOOGLE_AUTHENTICATOR) {
                Map config = (Map)mfaProvider.getValue().get("config");
                String providerDescription = (String)config.get("providerDescription");
                Integer digits = (Integer)config.get("digits");
                Integer duration = (Integer)config.get("duration");
                String algorithm = (String)config.get("algorithm");
                String issuer = (String)config.get("issuer");
                GoogleMfaProviderConfig defGoogleConfig = new GoogleMfaProviderConfig();
                defGoogleConfig.setIssuer(issuer);
                defGoogleConfig.setProviderDescription(providerDescription);
                def.setConfig((AbstractMfaProviderConfig)defGoogleConfig);
            }
            this.mfaProviders.add(def);
        }
    }
}

