/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.xml.bind.DatatypeConverter;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthenticationDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenIdSessionStateCalculator {
    private final String sessionId;
    private final String clientId;
    private final String origin;
    private final String salt;
    private final Logger logger = LoggerFactory.getLogger(OpenIdSessionStateCalculator.class);

    public OpenIdSessionStateCalculator(UaaAuthenticationDetails details, SecureRandom secureRandom) {
        this.sessionId = details.getSessionId();
        this.clientId = details.getClientId();
        this.origin = details.getOrigin();
        byte[] array = new byte[32];
        secureRandom.nextBytes(array);
        this.salt = DatatypeConverter.printHexBinary((byte[])array).toLowerCase();
    }

    public String calculate() {
        String text = String.format("%s %s %s %s", this.clientId, this.origin, this.sessionId, this.salt);
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(text.getBytes(StandardCharsets.UTF_8));
            return String.format("%s.%s", DatatypeConverter.printHexBinary((byte[])hash).toLowerCase(), this.salt);
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.error("Could not find algorithm SHA-256, aborting");
            return null;
        }
    }
}

