/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.orion;

import java.io.File;
import java.util.Iterator;
import org.apache.tools.ant.taskdefs.Ear;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileUtils;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.orion.internal.Oc4jExistingLocalConfigurationCapability;
import org.codehaus.cargo.container.spi.configuration.AbstractExistingLocalConfiguration;
import org.codehaus.cargo.util.CargoException;

public class Oc4j10xExistingLocalConfiguration
extends AbstractExistingLocalConfiguration {
    private static ConfigurationCapability capability = new Oc4jExistingLocalConfigurationCapability();

    public Oc4j10xExistingLocalConfiguration(String dir) {
        super(dir);
    }

    protected void doConfigure(LocalContainer container) throws Exception {
        FileUtils fileUtils = FileUtils.newFileUtils();
        String autoDeployDirSetting = this.getPropertyValue("cargo.oc4j.auto-deploy.dir");
        if (autoDeployDirSetting == null) {
            throw new CargoException("Can not start container without the cargo.oc4j.auto-deploy.dir property set");
        }
        File autoDeployDir = new File(autoDeployDirSetting);
        String appDir = autoDeployDir.getAbsolutePath();
        Iterator it = this.getDeployables().iterator();
        while (it.hasNext()) {
            Deployable deployable = (Deployable)it.next();
            if (deployable.getType() == DeployableType.EAR) {
                fileUtils.copyFile(deployable.getFile(), this.getFileHandler().append(appDir, this.getFileHandler().getName(deployable.getFile())), null, true);
                continue;
            }
            throw new CargoException("Only deployables of type " + DeployableType.EAR + " is supported");
        }
        Ear ear = (Ear)this.getAntUtils().createAntTask("ear");
        File tmpDir = new File(this.getFileHandler().createUniqueTmpDirectory());
        File appXml = new File(tmpDir, "application.xml");
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/cargocpc.war", new File(tmpDir, "cargocpc.war"));
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/oc4j10x/application.xml", appXml);
        ear.setAppxml(appXml);
        FileSet fileSet = new FileSet();
        fileSet.setDir(tmpDir);
        fileSet.createInclude().setName("cargocpc.war");
        ear.addFileset(fileSet);
        ear.setDestFile(new File(appDir, "cargocpc.ear"));
        ear.execute();
        this.getFileHandler().delete(tmpDir.getAbsolutePath());
    }

    public ConfigurationCapability getCapability() {
        return capability;
    }
}

