/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.orion.internal;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.filters.ReplaceTokens;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.util.FileUtils;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.EAR;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.orion.internal.OrionStandaloneLocalConfigurationCapability;
import org.codehaus.cargo.container.property.DataSource;
import org.codehaus.cargo.container.property.User;
import org.codehaus.cargo.container.spi.configuration.AbstractStandaloneLocalConfiguration;

public abstract class AbstractOrionStandaloneLocalConfiguration
extends AbstractStandaloneLocalConfiguration {
    private static ConfigurationCapability capability = new OrionStandaloneLocalConfigurationCapability();

    public AbstractOrionStandaloneLocalConfiguration(String dir) {
        super(dir);
        this.setProperty("cargo.rmi.port", "25791");
    }

    public ConfigurationCapability getCapability() {
        return capability;
    }

    protected void doConfigure(LocalContainer container) throws Exception {
        this.setupConfigurationDir();
        FileUtils fileUtils = FileUtils.newFileUtils();
        FilterChain filterChain = this.createOrionFilterChain();
        String confDir = this.getFileHandler().createDirectory(this.getHome(), "conf");
        String resourcePath = "/org/codehaus/cargo/container/internal/resources/orion1x2x";
        this.getResourceUtils().copyResource(resourcePath + "/server.xml", new File(confDir, "server.xml"), filterChain);
        this.getResourceUtils().copyResource(resourcePath + "/application.xml", new File(confDir, "application.xml"), filterChain);
        this.getResourceUtils().copyResource(resourcePath + "/default-web-site.xml", new File(confDir, "default-web-site.xml"), filterChain);
        this.getResourceUtils().copyResource(resourcePath + "/mime.types", new File(confDir, "mime.types"), filterChain);
        this.getResourceUtils().copyResource(resourcePath + "/principals.xml", new File(confDir, "principals.xml"), filterChain);
        this.getResourceUtils().copyResource(resourcePath + "/rmi.xml", new File(confDir, "rmi.xml"), filterChain);
        this.getResourceUtils().copyResource(resourcePath + "/data-sources.xml", new File(confDir, "data-sources.xml"), filterChain);
        this.copyCustomResources(new File(confDir), filterChain);
        String defaultWebAppDir = this.getFileHandler().createDirectory(this.getHome(), "default-web-app/WEB-INF");
        this.getResourceUtils().copyResource(resourcePath + "/web.xml", new File(defaultWebAppDir, "web.xml"), filterChain);
        this.getFileHandler().createDirectory(this.getHome(), "persistence");
        String appDir = this.getFileHandler().createDirectory(this.getHome(), "applications");
        this.getFileHandler().createDirectory(this.getHome(), "application-deployments");
        this.getFileHandler().createDirectory(this.getHome(), "log");
        Iterator it = this.getDeployables().iterator();
        while (it.hasNext()) {
            Deployable deployable = (Deployable)it.next();
            if (deployable.getType() == DeployableType.WAR && (deployable.getType() != DeployableType.WAR || ((WAR)deployable).isExpandedWar())) continue;
            fileUtils.copyFile(new File(deployable.getFile()).getAbsoluteFile(), new File(appDir, new File(deployable.getFile()).getName()), null, true);
        }
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/cargocpc.war", new File(appDir, "cargocpc.war"));
    }

    protected abstract void copyCustomResources(File var1, FilterChain var2) throws Exception;

    private FilterChain createOrionFilterChain() {
        FilterChain filterChain = this.getFilterChain();
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.rmi.port", this.getPropertyValue("cargo.rmi.port"));
        if (this.getPropertyValue("cargo.servlet.users") != null) {
            this.getAntUtils().addTokenToFilterChain(filterChain, "orion.users", this.getUserToken());
            this.getAntUtils().addTokenToFilterChain(filterChain, "orion.roles", this.getRoleToken());
        }
        this.getAntUtils().addTokenToFilterChain(filterChain, "orion.datasource", this.createDatasourceTokenValue());
        ReplaceTokens.Token tokenApplications = new ReplaceTokens.Token();
        tokenApplications.setKey("orion.application");
        ReplaceTokens.Token tokenWebModules = new ReplaceTokens.Token();
        tokenWebModules.setKey("orion.web-module");
        ReplaceTokens.Token tokenWebApps = new ReplaceTokens.Token();
        tokenWebApps.setKey("orion.web-app");
        StringBuffer keyApplications = new StringBuffer(" ");
        StringBuffer keyWebModules = new StringBuffer(" ");
        StringBuffer keyWebApps = new StringBuffer(" ");
        Iterator it = this.getDeployables().iterator();
        while (it.hasNext()) {
            Deployable deployable = (Deployable)it.next();
            if (deployable.getType() == DeployableType.EAR) {
                keyApplications.append("  <application name=\"");
                keyApplications.append(((EAR)deployable).getName());
                keyApplications.append("\" path=\"../applications/");
                keyApplications.append(new File(deployable.getFile()).getName());
                keyApplications.append("\"/>");
                Iterator itContexts = ((EAR)deployable).getWebContexts();
                while (itContexts.hasNext()) {
                    String webContext = (String)itContexts.next();
                    keyWebApps.append("<web-app application=\"");
                    keyWebApps.append(((EAR)deployable).getName());
                    keyWebApps.append("\" name=\"");
                    String name = ((EAR)deployable).getWebUri(webContext);
                    int warIndex = name.toLowerCase().lastIndexOf(".war");
                    if (warIndex >= 0) {
                        name = name.substring(0, warIndex);
                    }
                    keyWebApps.append(name);
                    keyWebApps.append("\" root=\"/");
                    keyWebApps.append(webContext);
                    keyWebApps.append("\"/>");
                }
                continue;
            }
            if (deployable.getType() != DeployableType.WAR) continue;
            keyWebModules.append("  <web-module id=\"");
            keyWebModules.append(((WAR)deployable).getContext());
            if (((WAR)deployable).isExpandedWar()) {
                keyWebModules.append("\" path=\"");
                keyWebModules.append(deployable.getFile());
            } else {
                keyWebModules.append("\" path=\"../applications/");
                keyWebModules.append(this.getFileHandler().getName(deployable.getFile()));
            }
            keyWebModules.append("\"/>");
            keyWebApps.append("<web-app application=\"default\" name=\"");
            keyWebApps.append(((WAR)deployable).getContext());
            keyWebApps.append("\" root=\"/");
            keyWebApps.append(((WAR)deployable).getContext());
            keyWebApps.append("\"/>");
        }
        tokenApplications.setValue(keyApplications.toString());
        tokenWebModules.setValue(keyWebModules.toString());
        tokenWebApps.setValue(keyWebApps.toString());
        ReplaceTokens replaceApplications = new ReplaceTokens();
        replaceApplications.addConfiguredToken(tokenApplications);
        filterChain.addReplaceTokens(replaceApplications);
        ReplaceTokens replaceWebModules = new ReplaceTokens();
        replaceWebModules.addConfiguredToken(tokenWebModules);
        filterChain.addReplaceTokens(replaceWebModules);
        ReplaceTokens replaceWebApps = new ReplaceTokens();
        replaceWebApps.addConfiguredToken(tokenWebApps);
        filterChain.addReplaceTokens(replaceWebApps);
        return filterChain;
    }

    protected String getUserToken() {
        StringBuffer token = new StringBuffer(" ");
        if (this.getPropertyValue("cargo.servlet.users") != null) {
            Iterator users = User.parseUsers((String)this.getPropertyValue("cargo.servlet.users")).iterator();
            while (users.hasNext()) {
                User user = (User)users.next();
                token.append("<user deactivated=\"false\" ");
                token.append("username=\"" + user.getName() + "\" ");
                token.append("password=\"" + user.getPassword() + "\"");
                token.append("/>");
            }
        }
        return token.toString();
    }

    protected String getRoleToken() {
        StringBuffer token = new StringBuffer(" ");
        List users = User.parseUsers((String)this.getPropertyValue("cargo.servlet.users"));
        Map roles = User.createRoleMap((List)users);
        Iterator roleIt = roles.keySet().iterator();
        while (roleIt.hasNext()) {
            String role = (String)roleIt.next();
            token.append("<security-role-mapping ");
            token.append("name=\"" + role + "\">");
            Iterator userIt = ((List)roles.get(role)).iterator();
            while (userIt.hasNext()) {
                User user = (User)userIt.next();
                token.append("<user name=\"" + user.getName() + "\"/>");
            }
            token.append("</security-role-mapping>");
        }
        return token.toString();
    }

    protected String createDatasourceTokenValue() {
        this.getLogger().debug("Orion createDatasourceTokenValue", ((Object)((Object)this)).getClass().getName());
        String dataSourceProperty = this.getPropertyValue("cargo.datasource.datasource");
        this.getLogger().debug("Datasource property value [" + dataSourceProperty + "]", ((Object)((Object)this)).getClass().getName());
        if (dataSourceProperty == null) {
            return " ";
        }
        DataSource ds = new DataSource(dataSourceProperty);
        return " <data-source\n    class='com.evermind.sql.DriverManagerDataSource' \n     name='Cargo-Datasource' \n    location='" + ds.getJndiLocation() + "' \n" + "    xa-location='" + ds.getJndiLocation() + "XA'\n" + "    ejb-location='" + ds.getJndiLocation() + "EJB'\n" + "    connection-driver='" + ds.getDriverClass() + "'\n" + "    username='" + ds.getUsername() + "'\n" + "    password='" + ds.getPassword() + "'\n" + "    url='" + ds.getUrl() + "'\n" + "    inactivity-timeout='30' \n" + "/>";
    }
}

