/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import org.exolab.javasource.JArrayType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JDocComment;
import org.exolab.javasource.JField;
import org.exolab.javasource.JMember;
import org.exolab.javasource.JMethodSignature;
import org.exolab.javasource.JModifiers;
import org.exolab.javasource.JParameter;
import org.exolab.javasource.JSourceWriter;
import org.exolab.javasource.JStructure;
import org.exolab.javasource.JType;

public final class JInterface
extends JStructure {
    private Map<String, JField> _fields = new LinkedHashMap<String, JField>();
    private Vector<JMethodSignature> _methods = new Vector();

    public JInterface(String name) {
        super(name);
        this.getJDocComment().appendComment("Interface " + this.getLocalName() + ".");
    }

    public void addImport(String className) {
        if (className == null || className.length() == 0) {
            return;
        }
        this.addImportInternal(className);
    }

    public void addMember(JMember jMember) {
        if (jMember == null) {
            throw new IllegalArgumentException("argument 'jMember' may not be null.");
        }
        if (!(jMember instanceof JField)) {
            throw new IllegalArgumentException("invalid member for JInterface: " + jMember.toString());
        }
        this.addField((JField)jMember);
    }

    public JField[] getFields() {
        return this._fields.values().toArray(new JField[this._fields.size()]);
    }

    public JField getField(String name) {
        return this._fields.get(name);
    }

    public void addField(JField jField) {
        if (jField == null) {
            throw new IllegalArgumentException("argument 'jField' cannot be null");
        }
        String name = jField.getName();
        if (this._fields != null && this._fields.get(name) != null) {
            String err = "duplicate name found: " + name;
            throw new IllegalArgumentException(err);
        }
        JModifiers modifiers = jField.getModifiers();
        if (!modifiers.isStatic()) {
            String err = "Fields added to a JInterface must be static.";
            throw new IllegalArgumentException(err);
        }
        if (modifiers.isPrivate()) {
            String err = "Fields added to a JInterface must not be private.";
            throw new IllegalArgumentException(err);
        }
        this._fields.put(name, jField);
        JType type = jField.getType();
        while (type.isArray()) {
            type = ((JArrayType)type).getComponentType();
        }
        if (!type.isPrimitive()) {
            this.addImport(((JClass)type).getName());
        }
        this.addImport(jField.getAnnotations());
    }

    public JMethodSignature[] getMethods() {
        Object[] marray = new JMethodSignature[this._methods.size()];
        this._methods.copyInto(marray);
        return marray;
    }

    public JMethodSignature getMethod(String name, int startIndex) {
        for (int i = startIndex; i < this._methods.size(); ++i) {
            JMethodSignature jMethod = this._methods.elementAt(i);
            if (!jMethod.getName().equals(name)) continue;
            return jMethod;
        }
        return null;
    }

    public JMethodSignature getMethod(int index) {
        return this._methods.elementAt(index);
    }

    public void addMethod(JMethodSignature jMethodSig) {
        if (jMethodSig == null) {
            String err = "The JMethodSignature cannot be null.";
            throw new IllegalArgumentException(err);
        }
        boolean added = false;
        JModifiers modifiers = jMethodSig.getModifiers();
        for (int i = 0; i < this._methods.size(); ++i) {
            JMethodSignature tmp = this._methods.elementAt(i);
            if (tmp.getModifiers().isProtected() && !modifiers.isProtected()) {
                this._methods.insertElementAt(jMethodSig, i);
                added = true;
                break;
            }
            if (jMethodSig.getName().compareTo(tmp.getName()) >= 0) continue;
            this._methods.insertElementAt(jMethodSig, i);
            added = true;
            break;
        }
        if (!added) {
            this._methods.addElement(jMethodSig);
        }
        String[] pkgNames = jMethodSig.getParameterClassNames();
        for (int i = 0; i < pkgNames.length; ++i) {
            this.addImport(pkgNames[i]);
        }
        JType jType = jMethodSig.getReturnType();
        if (jType != null) {
            while (jType.isArray()) {
                jType = ((JArrayType)jType).getComponentType();
            }
            if (!jType.isPrimitive()) {
                this.addImport(jType.getName());
            }
        }
        JClass[] exceptions = jMethodSig.getExceptions();
        for (int i = 0; i < exceptions.length; ++i) {
            this.addImport(exceptions[i].getName());
        }
        this.addImport(jMethodSig.getAnnotations());
        JParameter[] params = jMethodSig.getParameters();
        for (int i = 0; i < params.length; ++i) {
            this.addImport(params[i].getAnnotations());
        }
    }

    public void print(JSourceWriter jsw) {
        this.print(jsw, false);
    }

    public void print(JSourceWriter jsw, boolean classOnly) {
        if (jsw == null) {
            throw new IllegalArgumentException("argument 'jsw' should not be null.");
        }
        StringBuilder buffer = new StringBuilder(100);
        if (!classOnly) {
            this.printHeader(jsw);
            this.printPackageDeclaration(jsw);
            this.printImportDeclarations(jsw);
        }
        this.getJDocComment().print(jsw);
        this.getAnnotatedElementHelper().printAnnotations(jsw);
        buffer.setLength(0);
        JModifiers modifiers = this.getModifiers();
        if (modifiers.isPrivate()) {
            buffer.append("private ");
        } else if (modifiers.isPublic()) {
            buffer.append("public ");
        }
        if (modifiers.isAbstract()) {
            buffer.append("abstract ");
        }
        buffer.append("interface ");
        buffer.append(this.getLocalName());
        buffer.append(' ');
        if (this.getInterfaceCount() > 0) {
            Enumeration<String> enumeration = this.getInterfaces();
            boolean endl = false;
            if (this.getInterfaceCount() > 1) {
                jsw.writeln(buffer.toString());
                buffer.setLength(0);
                endl = true;
            }
            buffer.append("extends ");
            while (enumeration.hasMoreElements()) {
                buffer.append(enumeration.nextElement());
                if (!enumeration.hasMoreElements()) continue;
                buffer.append(", ");
            }
            if (endl) {
                jsw.writeln(buffer.toString());
                buffer.setLength(0);
            } else {
                buffer.append(' ');
            }
        }
        buffer.append('{');
        jsw.writeln(buffer.toString());
        buffer.setLength(0);
        jsw.writeln();
        jsw.indent();
        if (!this._fields.isEmpty()) {
            jsw.writeln();
            jsw.writeln("  //--------------------------/");
            jsw.writeln(" //- Class/Member Variables -/");
            jsw.writeln("//--------------------------/");
            jsw.writeln();
        }
        for (JField jField : this._fields.values()) {
            JDocComment comment = jField.getComment();
            if (comment != null) {
                comment.print(jsw);
            }
            jField.printAnnotations(jsw);
            jsw.write(jField.getModifiers().toString());
            jsw.write(32);
            JType type = jField.getType();
            String typeName = type.toString();
            if (typeName.equals(this.toString())) {
                typeName = type.getLocalName();
            }
            jsw.write(typeName);
            jsw.write(32);
            jsw.write(jField.getName());
            String init = jField.getInitString();
            if (init != null) {
                jsw.write(" = ");
                jsw.write(init);
            }
            jsw.writeln(';');
            jsw.writeln();
        }
        if (this._methods.size() > 0) {
            jsw.writeln();
            jsw.writeln("  //-----------/");
            jsw.writeln(" //- Methods -/");
            jsw.writeln("//-----------/");
            jsw.writeln();
        }
        for (int i = 0; i < this._methods.size(); ++i) {
            JMethodSignature signature = this._methods.elementAt(i);
            signature.print(jsw);
            jsw.writeln(';');
        }
        jsw.unindent();
        jsw.writeln('}');
        jsw.flush();
        jsw.close();
    }
}

