/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.descriptors;

import java.util.List;
import org.exolab.castor.builder.BuilderConfiguration;
import org.exolab.castor.builder.SGTypes;
import org.exolab.castor.builder.descriptors.DescriptorJClass;
import org.exolab.castor.builder.factory.XMLFieldHandlerFactory;
import org.exolab.castor.builder.info.ClassInfo;
import org.exolab.castor.builder.info.CollectionInfo;
import org.exolab.castor.builder.info.FieldInfo;
import org.exolab.castor.builder.info.NodeType;
import org.exolab.castor.builder.info.nature.XMLInfoNature;
import org.exolab.castor.builder.types.XSList;
import org.exolab.castor.builder.types.XSListType;
import org.exolab.castor.builder.types.XSType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JConstant;
import org.exolab.javasource.JConstructor;
import org.exolab.javasource.JNaming;
import org.exolab.javasource.JPrimitiveType;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public final class DescriptorSourceFactory {
    private static final JClass GENERALIZED_FIELD_HANDLER_CLASS = new JClass("org.exolab.castor.mapping.GeneralizedFieldHandler");
    private static final String FIELD_VALIDATOR_NAME = "fieldValidator";
    private final BuilderConfiguration _config;
    private XMLFieldHandlerFactory _xmlFieldHandlerFactory;

    public DescriptorSourceFactory(BuilderConfiguration config) {
        if (config == null) {
            String err = "The argument 'config' must not be null.";
            throw new IllegalArgumentException(err);
        }
        this._config = config;
        this._xmlFieldHandlerFactory = new XMLFieldHandlerFactory(config);
    }

    public JClass createSource(ClassInfo classInfo) {
        String xmlName;
        String nsURI;
        JClass jClass = classInfo.getJClass();
        String localClassName = jClass.getLocalName();
        String descriptorClassName = this.getQualifiedDescriptorClassName(jClass.getName());
        DescriptorJClass classDesc = new DescriptorJClass(this._config, descriptorClassName, jClass);
        JConstructor cons = classDesc.getConstructor(0);
        JSourceCode jsc = cons.getSourceCode();
        XMLInfoNature xmlNature = new XMLInfoNature(classInfo);
        String nsPrefix = xmlNature.getNamespacePrefix();
        if (nsPrefix != null && nsPrefix.length() > 0) {
            jsc.add("_nsPrefix = \"");
            jsc.append(nsPrefix);
            jsc.append("\";");
        }
        if ((nsURI = xmlNature.getNamespaceURI()) != null && nsURI.length() > 0) {
            jsc.add("_nsURI = \"");
            jsc.append(nsURI);
            jsc.append("\";");
        }
        if ((xmlName = xmlNature.getNodeName()) != null) {
            jsc.add("_xmlName = \"");
            jsc.append(xmlName);
            jsc.append("\";");
        }
        boolean elementDefinition = xmlNature.isElementDefinition();
        jsc.add("_elementDefinition = ");
        jsc.append(Boolean.toString(elementDefinition));
        jsc.append(";");
        if (xmlNature.isChoice()) {
            jsc.add("");
            jsc.add("//-- set grouping compositor");
            jsc.add("setCompositorAsChoice();");
        } else if (xmlNature.isSequence()) {
            jsc.add("");
            jsc.add("//-- set grouping compositor");
            jsc.add("setCompositorAsSequence();");
        }
        List<String> substitutionGroups = xmlNature.getSubstitutionGroups();
        if (!substitutionGroups.isEmpty()) {
            jsc.add("java.util.List substitutionGroups = new java.util.ArrayList();");
            for (String substitutionGroup : substitutionGroups) {
                jsc.add("substitutionGroups.add(\"");
                jsc.append(substitutionGroup);
                jsc.append("\");");
            }
            jsc.add("setSubstitutes(substitutionGroups);");
        }
        if (classInfo.getFieldCount() == 0) {
            return classDesc;
        }
        jsc.add("org.exolab.castor.xml.util.XMLFieldDescriptorImpl  desc           = null;");
        jsc.add("org.exolab.castor.mapping.FieldHandler             handler        = null;");
        jsc.add("org.exolab.castor.xml.FieldValidator               fieldValidator = null;");
        if (classInfo.allowContent()) {
            this.createDescriptor(classDesc, classInfo.getTextField(), localClassName, null, jsc);
        }
        ClassInfo base = classInfo.getBaseClass();
        FieldInfo[] atts = classInfo.getAttributeFields();
        jsc.add("//-- initialize attribute descriptors");
        jsc.add("");
        for (FieldInfo member : atts) {
            if (member.isTransient()) continue;
            if (base != null) {
                String baseNodeName = new XMLInfoNature(member).getNodeName();
                if (baseNodeName.equals("-error-if-this-is-used-")) {
                    this.createDescriptor(classDesc, member, localClassName, nsURI, jsc);
                    continue;
                }
                if (base.getAttributeField(baseNodeName) != null) {
                    DescriptorSourceFactory.createRestrictedDescriptor(member, jsc);
                    continue;
                }
                this.createDescriptor(classDesc, member, localClassName, nsURI, jsc);
                continue;
            }
            this.createDescriptor(classDesc, member, localClassName, nsURI, jsc);
        }
        FieldInfo[] elements = classInfo.getElementFields();
        jsc.add("//-- initialize element descriptors");
        jsc.add("");
        for (FieldInfo member : elements) {
            XMLInfoNature fieldNature = new XMLInfoNature(member);
            if (member.isTransient()) continue;
            if (base != null) {
                String baseNodeName = fieldNature.getNodeName();
                if (baseNodeName == null) {
                    this.createDescriptor(classDesc, member, localClassName, nsURI, jsc);
                    continue;
                }
                if (baseNodeName.equals("-error-if-this-is-used-")) {
                    this.createDescriptor(classDesc, member, localClassName, nsURI, jsc);
                    continue;
                }
                if (base.getElementField(baseNodeName) != null) {
                    DescriptorSourceFactory.createRestrictedDescriptor(member, jsc);
                    continue;
                }
                this.createDescriptor(classDesc, member, localClassName, nsURI, jsc);
                continue;
            }
            this.createDescriptor(classDesc, member, localClassName, nsURI, jsc);
        }
        return classDesc;
    }

    private String getQualifiedDescriptorClassName(String name) {
        String descPackage = JNaming.getPackageFromClassName(name);
        String descClassName = JNaming.getLocalNameFromClassName(name);
        descPackage = descPackage != null && descPackage.length() > 0 ? descPackage + "." + "descriptors" + "." : "";
        return descPackage + descClassName + "Descriptor";
    }

    private static void createRestrictedDescriptor(FieldInfo member, JSourceCode jsc) {
        jsc.add("desc = (org.exolab.castor.xml.util.XMLFieldDescriptorImpl) getFieldDescriptor(\"");
        XMLInfoNature xmlNature = new XMLInfoNature(member);
        jsc.append(xmlNature.getNodeName());
        jsc.append("\"");
        jsc.append(", _nsURI");
        NodeType nodeType = xmlNature.getNodeType();
        if (nodeType == NodeType.ELEMENT) {
            jsc.append(", org.exolab.castor.xml.NodeType.Element);");
        } else if (nodeType == NodeType.ATTRIBUTE) {
            jsc.append(", org.exolab.castor.xml.NodeType.Attribute);");
        } else {
            jsc.append("org.exolab.castor.xml.NodeType.Text);");
        }
        if (xmlNature.isRequired()) {
            jsc.add("desc.setRequired(true);");
        }
        DescriptorSourceFactory.addValidationCode(member, jsc);
    }

    private void createDescriptor(DescriptorJClass classDesc, FieldInfo member, String localClassName, String nsURI, JSourceCode jsc) {
        XMLInfoNature xmlNature = new XMLInfoNature(member);
        XSType xsType = xmlNature.getSchemaType();
        XSType xsCollectionType = null;
        boolean any = false;
        NodeType nodeType = xmlNature.getNodeType();
        boolean isElement = nodeType == NodeType.ELEMENT;
        boolean isAttribute = nodeType == NodeType.ATTRIBUTE;
        boolean isText = nodeType == NodeType.TEXT;
        jsc.add("//-- ");
        jsc.append(member.getName());
        if (member.getName().equals("_anyObject")) {
            any = true;
        }
        if (xsType.isCollection()) {
            xsCollectionType = xsType;
            xsType = new XMLInfoNature(((CollectionInfo)member).getContent()).getSchemaType();
        }
        String nodeName = xmlNature.getNodeName();
        String nodeNameParam = null;
        if (nodeName != null && !isText) {
            nodeNameParam = "\"" + nodeName + "\"";
            if (this._config.classDescFieldNames()) {
                nodeNameParam = nodeName.toUpperCase();
                JConstant constant = new JConstant(SGTypes.STRING, nodeNameParam);
                constant.setInitString("\"" + nodeName + "\"");
                classDesc.addMember(constant);
            }
        }
        jsc.add("desc = new org.exolab.castor.xml.util.XMLFieldDescriptorImpl(");
        jsc.append(DescriptorSourceFactory.classType(xsType.getJType()));
        jsc.append(", \"");
        jsc.append(member.getName());
        jsc.append("\", ");
        if (nodeNameParam != null) {
            jsc.append(nodeNameParam);
        } else if (isText) {
            jsc.append("\"PCDATA\"");
        } else {
            jsc.append("(java.lang.String) null");
        }
        if (isElement) {
            jsc.append(", org.exolab.castor.xml.NodeType.Element);");
        } else if (isAttribute) {
            jsc.append(", org.exolab.castor.xml.NodeType.Attribute);");
        } else if (isText) {
            jsc.append(", org.exolab.castor.xml.NodeType.Text);");
        }
        switch (xsType.getType()) {
            case 1: {
                jsc.add("desc.setImmutable(true);");
                break;
            }
            case 26: {
                jsc.add("desc.setReference(true);");
                break;
            }
            case 25: {
                jsc.add("this._identity = desc;");
                break;
            }
            case 18: {
                jsc.add("desc.setSchemaType(\"QName\");");
                break;
            }
        }
        if (member.getXMLFieldHandler() != null) {
            String handler = member.getXMLFieldHandler();
            jsc.add("handler = new " + handler + "();");
            jsc.add("//-- test for generalized field handler");
            jsc.add("if (handler instanceof ");
            jsc.append(GENERALIZED_FIELD_HANDLER_CLASS.getName());
            jsc.append(")");
            jsc.add("{");
            jsc.indent();
            jsc.add("//-- save reference to user-specified handler");
            jsc.add(GENERALIZED_FIELD_HANDLER_CLASS.getName());
            jsc.append(" gfh = (");
            jsc.append(GENERALIZED_FIELD_HANDLER_CLASS.getName());
            jsc.append(") handler;");
            this._xmlFieldHandlerFactory.createXMLFieldHandler(member, xsType, localClassName, jsc, true);
            jsc.add("gfh.setFieldHandler(handler);");
            jsc.add("handler = gfh;");
            jsc.unindent();
            jsc.add("}");
        } else {
            this._xmlFieldHandlerFactory.createXMLFieldHandler(member, xsType, localClassName, jsc, false);
            this.addSpecialHandlerLogic(member, xsType, jsc);
        }
        if (xsCollectionType == null) {
            jsc.add("desc.setSchemaType(\"" + xsType.getName() + "\");");
        } else {
            jsc.add("desc.setSchemaType(\"list\");");
            jsc.add("desc.setComponentType(\"" + xsType.getName() + "\");");
            if (xsCollectionType instanceof XSList && ((XSList)xsCollectionType).isDerivedFromXSList()) {
                jsc.add("desc.setDerivedFromXSList(true);");
            }
        }
        jsc.add("desc.setHandler(handler);");
        if (member.isContainer()) {
            jsc.add("desc.setContainer(true);");
            String className = xsType.getName();
            if (className.equals(localClassName)) {
                jsc.add("desc.setClassDescriptor(this);");
            } else {
                String descriptorClassName = this.getQualifiedDescriptorClassName(className);
                jsc.add("desc.setClassDescriptor(new " + descriptorClassName + "());");
            }
        }
        if (xmlNature.getNamespaceURI() != null) {
            jsc.add("desc.setNameSpaceURI(\"");
            jsc.append(xmlNature.getNamespaceURI());
            jsc.append("\");");
        }
        if (xmlNature.isRequired()) {
            jsc.add("desc.setRequired(true);");
        }
        if (member.isNillable()) {
            jsc.add("desc.setNillable(true);");
        }
        if (any) {
            jsc.add("desc.setMatches(\"*\");");
        }
        if (isElement || isAttribute) {
            jsc.add("desc.setMultivalued(" + xmlNature.isMultivalued());
            jsc.append(");");
        }
        jsc.add("addFieldDescriptor(desc);");
        if (isElement) {
            jsc.add("addSequenceElement(desc);");
        }
        jsc.add("");
        if (isElement) {
            this.addSubstitutionGroups(member, jsc);
        }
        DescriptorSourceFactory.addValidationCode(member, jsc);
    }

    private void addSubstitutionGroups(FieldInfo member, JSourceCode jsc) {
        List<String> substitutionGroupMembers = member.getSubstitutionGroupMembers();
        if (!substitutionGroupMembers.isEmpty()) {
            jsc.add("// set possible substitutes for member " + member.getName());
            jsc.add("java.util.List substitutionGroups" + member.getName() + " = new java.util.ArrayList();");
            for (String substitutionGroup : substitutionGroupMembers) {
                jsc.add("substitutionGroups" + member.getName() + ".add(\"");
                jsc.append(substitutionGroup);
                jsc.append("\");");
            }
            jsc.add("desc.setSubstitutes(substitutionGroups" + member.getName() + ");");
        }
    }

    private void addSpecialHandlerLogic(FieldInfo member, XSType xsType, JSourceCode jsc) {
        XMLInfoNature xmlNature = new XMLInfoNature(member);
        if (xsType.isEnumerated()) {
            jsc.add("handler = new org.exolab.castor.xml.handlers.EnumFieldHandler(");
            jsc.append(DescriptorSourceFactory.classType(xsType.getJType()));
            jsc.append(", handler);");
            jsc.add("desc.setImmutable(true);");
        } else if (xsType.getType() == 3) {
            jsc.add("handler = new org.exolab.castor.xml.handlers.DateFieldHandler(");
            jsc.append("handler);");
            jsc.add("desc.setImmutable(true);");
        } else if (xsType.getType() == 16) {
            jsc.add("desc.setImmutable(true);");
        } else if (xmlNature.getSchemaType().isCollection()) {
            switch (xsType.getType()) {
                case 30: 
                case 31: {
                    jsc.add("handler = new org.exolab.castor.xml.handlers.CollectionFieldHandler(");
                    jsc.append("handler, new org.exolab.castor.xml.validators.NameValidator(");
                    jsc.append("org.exolab.castor.xml.XMLConstants.NAME_TYPE_NMTOKEN));");
                    break;
                }
                case 18: {
                    jsc.add("handler = new org.exolab.castor.xml.handlers.CollectionFieldHandler(");
                    jsc.append("handler, null);");
                    break;
                }
                case 26: 
                case 27: {
                    jsc.add("desc.setMultivalued(");
                    jsc.append("" + xmlNature.isMultivalued());
                    jsc.append(");");
                    break;
                }
            }
        }
    }

    private static void addValidationCode(FieldInfo member, JSourceCode jsc) {
        if (member == null || jsc == null) {
            return;
        }
        jsc.add("//-- validation code for: ");
        jsc.append(member.getName());
        String validator = member.getValidator();
        if (validator != null && validator.length() > 0) {
            jsc.add("fieldValidator = new " + validator + "();");
        } else {
            jsc.add("fieldValidator = new org.exolab.castor.xml.FieldValidator();");
            if (member.getName().equals("_anyObject")) {
                jsc.add("desc.setValidator(fieldValidator);");
                return;
            }
            XMLInfoNature xmlNature = new XMLInfoNature(member);
            XSType xsType = xmlNature.getSchemaType();
            if (xsType.isCollection()) {
                XSListType xsList = (XSListType)xsType;
                jsc.add("fieldValidator.setMinOccurs(");
                jsc.append(Integer.toString(xsList.getMinimumSize()));
                jsc.append(");");
                if (xsList.getMaximumSize() > 0) {
                    jsc.add("fieldValidator.setMaxOccurs(");
                    jsc.append(Integer.toString(xsList.getMaximumSize()));
                    jsc.append(");");
                }
            } else if (xmlNature.isRequired()) {
                jsc.add("fieldValidator.setMinOccurs(1);");
            }
            jsc.add("{ //-- local scope");
            jsc.indent();
            xsType.validationCode(jsc, member.getFixedValue(), FIELD_VALIDATOR_NAME);
            jsc.unindent();
            jsc.add("}");
        }
        jsc.add("desc.setValidator(fieldValidator);");
    }

    private static String classType(JType jType) {
        if (jType.isPrimitive()) {
            JPrimitiveType primitive = (JPrimitiveType)jType;
            return primitive.getWrapperName() + ".TYPE";
        }
        return jType.toString() + ".class";
    }
}

