/*
 * Decompiled with CFR 0.152.
 */
package org.castor.core.util;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.castor.core.util.IdentitySet;

public final class IdentityMap
implements Map {
    private static final int DEFAULT_CAPACITY = 17;
    private static final float DEFAULT_LOAD = 0.75f;
    private static final int DEFAULT_ENTRIES = 12;
    private static final int DEFAULT_INCREMENT = 2;
    private static final int FIRST_PRIME_TO_CHECK = 3;
    private int _capacity = 17;
    private int _maximum = 12;
    private Entry[] _buckets = new Entry[17];
    private int _entries = 0;

    @Override
    public void clear() {
        this._capacity = 17;
        this._maximum = 12;
        this._buckets = new Entry[17];
        this._entries = 0;
    }

    @Override
    public int size() {
        return this._entries;
    }

    @Override
    public boolean isEmpty() {
        return this._entries == 0;
    }

    public Object put(Object key, Object value) {
        int hash = System.identityHashCode(key);
        int index = hash % this._capacity;
        if (index < 0) {
            index = -index;
        }
        Entry prev = null;
        for (Entry entry = this._buckets[index]; entry != null; entry = entry.getNext()) {
            if (entry.getKey() == key) {
                Object ret = entry.getValue();
                entry.setValue(value);
                return ret;
            }
            prev = entry;
        }
        if (prev == null) {
            this._buckets[index] = new Entry(key, hash, value);
        } else {
            prev.setNext(new Entry(key, hash, value));
        }
        ++this._entries;
        if (this._entries > this._maximum) {
            this.rehash();
        }
        return null;
    }

    private void rehash() {
        long nextCapacity = this._capacity * 2;
        if (nextCapacity > Integer.MAX_VALUE) {
            return;
        }
        if ((nextCapacity = this.nextPrime(nextCapacity)) > Integer.MAX_VALUE) {
            return;
        }
        int newCapacity = (int)nextCapacity;
        Entry[] newBuckets = new Entry[newCapacity];
        Entry entry = null;
        Entry temp = null;
        Entry next = null;
        int newIndex = 0;
        for (int index = 0; index < this._capacity; ++index) {
            entry = this._buckets[index];
            while (entry != null) {
                next = entry.getNext();
                newIndex = entry.getHash() % newCapacity;
                if (newIndex < 0) {
                    newIndex = -newIndex;
                }
                if ((temp = newBuckets[newIndex]) == null) {
                    entry.setNext(null);
                } else {
                    entry.setNext(temp);
                }
                newBuckets[newIndex] = entry;
                entry = next;
            }
        }
        this._capacity = newCapacity;
        this._maximum = (int)((float)newCapacity * 0.75f);
        this._buckets = newBuckets;
    }

    private long nextPrime(long minimum) {
        long candidate = (minimum + 1L) / 2L * 2L + 1L;
        while (!this.isPrime(candidate)) {
            candidate += 2L;
        }
        return candidate;
    }

    private boolean isPrime(long candidate) {
        if (candidate / 2L * 2L == candidate) {
            return false;
        }
        long stop = candidate / 2L;
        for (long i = 3L; i < stop; i += 2L) {
            if (candidate / i * i != candidate) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(Object key) {
        int hash = System.identityHashCode(key);
        int index = hash % this._capacity;
        if (index < 0) {
            index = -index;
        }
        for (Entry entry = this._buckets[index]; entry != null; entry = entry.getNext()) {
            if (entry.getKey() != key) continue;
            return true;
        }
        return false;
    }

    public Object get(Object key) {
        int hash = System.identityHashCode(key);
        int index = hash % this._capacity;
        if (index < 0) {
            index = -index;
        }
        for (Entry entry = this._buckets[index]; entry != null; entry = entry.getNext()) {
            if (entry.getKey() != key) continue;
            return entry.getValue();
        }
        return null;
    }

    public Object remove(Object key) {
        int hash = System.identityHashCode(key);
        int index = hash % this._capacity;
        if (index < 0) {
            index = -index;
        }
        Entry prev = null;
        for (Entry entry = this._buckets[index]; entry != null; entry = entry.getNext()) {
            if (entry.getKey() == key) {
                if (prev == null) {
                    this._buckets[index] = entry.getNext();
                } else {
                    prev.setNext(entry.getNext());
                }
                --this._entries;
                return entry.getValue();
            }
            prev = entry;
        }
        return null;
    }

    public Set keySet() {
        IdentitySet set = new IdentitySet(this._capacity);
        for (int i = 0; i < this._capacity; ++i) {
            for (Entry entry = this._buckets[i]; entry != null; entry = entry.getNext()) {
                set.add(entry.getKey());
            }
        }
        return set;
    }

    public Set entrySet() {
        IdentitySet set = new IdentitySet(this._capacity);
        for (int i = 0; i < this._capacity; ++i) {
            for (Entry entry = this._buckets[i]; entry != null; entry = entry.getNext()) {
                set.add(entry);
            }
        }
        return set;
    }

    public Collection values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map map) {
        throw new UnsupportedOperationException();
    }

    public final class Entry
    implements Map.Entry {
        private Object _key;
        private int _hash;
        private Object _value;
        private Entry _next = null;

        public Entry(Object key, int hash, Object value) {
            this._key = key;
            this._hash = hash;
            this._value = value;
        }

        public Object getKey() {
            return this._key;
        }

        public int getHash() {
            return this._hash;
        }

        public Object setValue(Object value) {
            Object temp = this._value;
            this._value = value;
            return temp;
        }

        public Object getValue() {
            return this._value;
        }

        public void setNext(Entry next) {
            this._next = next;
        }

        public Entry getNext() {
            return this._next;
        }
    }
}

