/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.util.RegExpEvaluator;

public class XercesRegExpEvaluator
implements RegExpEvaluator {
    private static final Log LOG = LogFactory.getLog(XercesRegExpEvaluator.class);
    private static final String BOL = "^";
    private static final String EOL = "$";
    private static final String CLASS_NAME = "org.apache.xerces.utils.regex.RegularExpression";
    Object _regexp = null;
    private Constructor _constructor;

    public XercesRegExpEvaluator() {
        try {
            Class<?> regexpClass = Class.forName(CLASS_NAME);
            this._constructor = regexpClass.getConstructor(String.class);
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)"Problem loading class org.apache.xerces.utils.regex.RegularExpression", (Throwable)e);
            throw new IllegalAccessError("Problem loading class org.apache.xerces.utils.regex.RegularExpression: " + e.getMessage());
        }
        catch (SecurityException e) {
            LOG.error((Object)"Problem accessing constructor of class org.apache.xerces.utils.regex.RegularExpression", (Throwable)e);
            throw new IllegalAccessError("Problem accessnig constructor of class org.apache.xerces.utils.regex.RegularExpression: " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            LOG.error((Object)"Problem locating constructor of class org.apache.xerces.utils.regex.RegularExpression", (Throwable)e);
            throw new IllegalAccessError("class org.apache.xerces.utils.regex.RegularExpression: " + e.getMessage());
        }
    }

    public void setExpression(String rexpr) {
        if (rexpr != null) {
            try {
                this._regexp = this._constructor.newInstance(BOL + rexpr + EOL);
            }
            catch (Exception e) {
                LOG.error((Object)"Problem invoking constructor on org.apache.xerces.utils.regex.RegularExpression", (Throwable)e);
                String err = "XercesRegExp Syntax error: " + e.getMessage() + " ; error occured with the following " + "regular expression: " + rexpr;
                throw new IllegalArgumentException(err);
            }
        } else {
            this._regexp = null;
        }
    }

    public boolean matches(String value) {
        if (this._regexp != null) {
            try {
                Method method = this._regexp.getClass().getMethod("matches", String.class);
                return (Boolean)method.invoke(this._regexp, value);
            }
            catch (SecurityException e) {
                LOG.error((Object)"Security problem accessing matches(String) method of class org.apache.xerces.utils.regex.RegularExpression", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                LOG.error((Object)"Method matches(String) of class org.apache.xerces.utils.regex.RegularExpression could not be found.", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                LOG.error((Object)"Invalid argument provided to method matches(String) of class org.apache.xerces.utils.regex.RegularExpression", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.error((Object)"Illegal acces to method matches(String) of class org.apache.xerces.utils.regex.RegularExpression", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOG.error((Object)"Invalid invocation of method matches(String) of class org.apache.xerces.utils.regex.RegularExpression", (Throwable)e);
            }
        }
        return true;
    }
}

