/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.MappingLoader;
import org.exolab.castor.xml.ResolverException;
import org.exolab.castor.xml.util.ClassDescriptorResolutionCommand;
import org.exolab.castor.xml.util.ClassLoaderNature;
import org.exolab.castor.xml.util.ClassResolutionByCDR;
import org.exolab.castor.xml.util.ClassResolutionByFile;
import org.exolab.castor.xml.util.ClassResolutionByMappingLoader;
import org.exolab.castor.xml.util.JDOClassDescriptorResolver;
import org.exolab.castor.xml.util.MappingLoaderNature;
import org.exolab.castor.xml.util.PackageBasedCDRResolutionNature;

public class JDOClassDescriptorResolverImpl
implements JDOClassDescriptorResolver {
    private Map _classDescriptorCache = new HashMap();
    private MappingLoader _mappingLoader;
    protected List _classes = new LinkedList();
    protected List _packages = new LinkedList();
    private Map _commands = new HashMap();

    public JDOClassDescriptorResolverImpl() {
        this.registerCommand(new ClassResolutionByMappingLoader());
        this.registerCommand(new ClassResolutionByFile());
        this.registerCommand(new ClassResolutionByCDR());
    }

    private void registerCommand(ClassDescriptorResolutionCommand command) {
        this._commands.put(command.getClass().getName(), command);
    }

    public ClassDescriptor resolve(String type) throws ResolverException {
        try {
            if (this.getMappingLoader().getClassLoader() != null) {
                return this.resolve(this.getMappingLoader().getClassLoader().loadClass(type));
            }
            return this.resolve(Class.forName(type));
        }
        catch (ClassNotFoundException e) {
            throw new ResolverException("Problem loading class " + type);
        }
    }

    public ClassDescriptor resolve(Class type) throws ResolverException {
        if (type == null) {
            return null;
        }
        ClassDescriptor classDesc = null;
        classDesc = this.resolveByCache(type);
        if (classDesc != null) {
            return classDesc;
        }
        classDesc = this.lookup(ClassResolutionByMappingLoader.class.getName()).resolve(type);
        if (classDesc != null) {
            this._classDescriptorCache.put(type, classDesc);
            return classDesc;
        }
        classDesc = this.lookup(ClassResolutionByFile.class.getName()).resolve(type);
        if (classDesc != null) {
            this._classDescriptorCache.put(type, classDesc);
            return classDesc;
        }
        classDesc = this.lookup(ClassResolutionByCDR.class.getName()).resolve(type);
        if (classDesc != null) {
            this._classDescriptorCache.put(type, classDesc);
            return classDesc;
        }
        return classDesc;
    }

    private ClassDescriptorResolutionCommand lookup(String commandName) {
        return (ClassDescriptorResolutionCommand)this._commands.get(commandName);
    }

    private ClassDescriptor resolveByCache(Class type) {
        ClassDescriptor classDesc = null;
        classDesc = (ClassDescriptor)this._classDescriptorCache.get(type);
        return classDesc;
    }

    public MappingLoader getMappingLoader() {
        return this._mappingLoader;
    }

    public void setMappingLoader(MappingLoader mappingLoader) {
        this._mappingLoader = mappingLoader;
        for (ClassDescriptorResolutionCommand command : this._commands.values()) {
            if (command.hasNature(MappingLoaderNature.class.getName())) {
                new MappingLoaderNature(command).setMappingLoader(mappingLoader);
            }
            if (!command.hasNature(ClassLoaderNature.class.getName())) continue;
            new ClassLoaderNature(command).setClassLoader(this._mappingLoader.getClassLoader());
        }
    }

    public void addClass(Class domainClass) {
        this._classes.add(domainClass);
    }

    public void addPackage(String packageName) {
        this._packages.add(packageName);
        for (ClassDescriptorResolutionCommand command : this._commands.values()) {
            if (!command.hasNature(PackageBasedCDRResolutionNature.class.getName())) continue;
            new PackageBasedCDRResolutionNature(command).addPackageName(packageName);
        }
    }

    public Iterator descriptorIterator() {
        ArrayList<ClassDescriptor> allDescriptors = new ArrayList<ClassDescriptor>();
        allDescriptors.addAll(this._mappingLoader.getDescriptors());
        Iterator iterator = this._classes.iterator();
        while (iterator.hasNext()) {
            allDescriptors.add(this.lookup(ClassResolutionByFile.class.getName()).resolve((Class)iterator.next()));
        }
        ClassResolutionByCDR cdrNature = (ClassResolutionByCDR)this.lookup(ClassResolutionByCDR.class.getName());
        for (String packageName : this._packages) {
            Map descriptors = cdrNature.getDescriptors(packageName);
            for (Map.Entry entry : descriptors.entrySet()) {
                allDescriptors.add((ClassDescriptor)entry.getValue());
            }
        }
        return allDescriptors.iterator();
    }

    public ClassLoader getClassLoader() {
        return this._mappingLoader.getClassLoader();
    }
}

