/*
 * Decompiled with CFR 0.152.
 */
package org.castor.spring.xml;

import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.mapping.BindingType;
import org.castor.mapping.MappingUnmarshaller;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.MappingLoader;
import org.exolab.castor.xml.ClassDescriptorResolver;
import org.exolab.castor.xml.ClassDescriptorResolverFactory;
import org.exolab.castor.xml.XMLClassDescriptorResolver;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.xml.sax.InputSource;

public class CastorResolverFactoryBean
implements FactoryBean,
InitializingBean {
    private static final Log LOG = LogFactory.getLog(CastorResolverFactoryBean.class);
    private Properties castorProperties;
    private List mappingLocations;
    private XMLClassDescriptorResolver resolver;

    public void afterPropertiesSet() throws Exception {
        this.resolver = (XMLClassDescriptorResolver)ClassDescriptorResolverFactory.createClassDescriptorResolver((BindingType)BindingType.XML);
        String mappingLocation = null;
        if (this.mappingLocations != null && this.mappingLocations.size() > 0) {
            Iterator iter = this.mappingLocations.iterator();
            try {
                Mapping mapping = new Mapping();
                while (iter.hasNext()) {
                    mappingLocation = (String)iter.next();
                    URL mappingResource = this.getClass().getClassLoader().getResource(mappingLocation);
                    mapping.loadMapping(new InputSource(mappingResource.openStream()));
                }
                MappingUnmarshaller mappingUnmarshaller = new MappingUnmarshaller();
                MappingLoader loader = mappingUnmarshaller.getMappingLoader(mapping, BindingType.XML);
                this.resolver.setMappingLoader(loader);
            }
            catch (MappingException e) {
                LOG.error((Object)("Problem locating/loading Castor mapping file from location " + mappingLocation), (Throwable)e);
                throw e;
            }
        }
    }

    public Object getObject() throws Exception {
        return this.resolver;
    }

    public Class getObjectType() {
        if (this.resolver == null) {
            return ClassDescriptorResolver.class;
        }
        return this.resolver.getClass();
    }

    public boolean isSingleton() {
        return true;
    }

    public void setCastorProperties(Properties castorProperties) {
        this.castorProperties = castorProperties;
    }

    public void setMappingLocations(List mappingLocations) {
        this.mappingLocations = mappingLocations;
    }
}

