/*
 * Decompiled with CFR 0.152.
 */
package org.castor.spring.xml;

import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.mapping.BindingType;
import org.castor.mapping.MappingUnmarshaller;
import org.castor.spring.xml.InternalContextAdapter;
import org.castor.spring.xml.NoInternalContextAdapter;
import org.castor.spring.xml.SpringXMLContext;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.MappingLoader;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.xml.sax.InputSource;

public class CastorXMLContextFactoryBean
implements FactoryBean,
InitializingBean {
    private static final Log LOG = LogFactory.getLog(CastorXMLContextFactoryBean.class);
    private SpringXMLContext springXmlContext;
    private List mappingLocations;

    public void afterPropertiesSet() throws Exception {
        this.springXmlContext = this.internalContextExists() ? new InternalContextAdapter() : new NoInternalContextAdapter();
        this.readMappings();
    }

    private boolean internalContextExists() {
        try {
            Class.forName("org.castor.xml.InternalContext");
            return true;
        }
        catch (ClassNotFoundException e) {
            LOG.debug((Object)("failed to load InternalContext class - working against old Castor release... - exception was: " + e));
            return false;
        }
    }

    private void readMappings() throws MappingException, IOException {
        String mappingLocation = null;
        if (this.mappingLocations != null && this.mappingLocations.size() > 0) {
            Iterator iter = this.mappingLocations.iterator();
            try {
                Mapping mapping = new Mapping();
                while (iter.hasNext()) {
                    mappingLocation = (String)iter.next();
                    URL mappingResource = this.getClass().getClassLoader().getResource(mappingLocation);
                    mapping.loadMapping(new InputSource(mappingResource.openStream()));
                }
                MappingUnmarshaller mappingUnmarshaller = new MappingUnmarshaller();
                MappingLoader loader = mappingUnmarshaller.getMappingLoader(mapping, BindingType.XML);
                this.springXmlContext.setMappingLoader(loader);
            }
            catch (MappingException e) {
                LOG.error((Object)("Problem locating/loading Castor mapping file from location " + mappingLocation), (Throwable)e);
                throw e;
            }
            catch (IOException e) {
                LOG.error((Object)("Problem locating/loading Castor mapping file from location " + mappingLocation), (Throwable)e);
                throw e;
            }
        }
    }

    public Object getObject() throws Exception {
        return this.springXmlContext;
    }

    public Class getObjectType() {
        if (this.springXmlContext == null) {
            return SpringXMLContext.class;
        }
        return this.springXmlContext.getClass();
    }

    public boolean isSingleton() {
        return true;
    }

    public void setMappingLocations(List mappingLocations) {
        this.mappingLocations = mappingLocations;
    }
}

