/*
 * Decompiled with CFR 0.152.
 */
package org.castor.spring.xml;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.spring.xml.DataBindingOperations;
import org.castor.spring.xml.MarshallingException;
import org.castor.spring.xml.ValidationException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.xml.sax.InputSource;

public class DataBindingTemplate
implements DataBindingOperations {
    private static final Log LOG = LogFactory.getLog(DataBindingTemplate.class);
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;

    public void marshal(Object object, Writer writer) throws MarshallingException, IOException, ValidationException {
        this.marshaller.setWriter(writer);
        try {
            this.marshaller.marshal(object);
        }
        catch (MarshalException e) {
            LOG.warn((Object)("Unmarshal failed with exception: " + (Object)((Object)e)));
            throw new MarshallingException(e.getMessage(), e);
        }
        catch (org.exolab.castor.xml.ValidationException e) {
            LOG.warn((Object)("Unmarshal failed with exception: " + (Object)((Object)e)));
            throw new ValidationException(e.getMessage(), e);
        }
    }

    public Object unmarshal(InputSource inputSource, Class type) throws MarshallingException, IOException, ValidationException {
        Object object;
        try {
            object = this.unmarshaller.unmarshal(inputSource);
        }
        catch (MarshalException e) {
            LOG.warn((Object)("Unmarshal failed with exception: " + (Object)((Object)e)));
            throw new MarshallingException(e.getMessage(), e);
        }
        catch (org.exolab.castor.xml.ValidationException e) {
            LOG.warn((Object)("Unmarshal failed with exception: " + (Object)((Object)e)));
            throw new ValidationException(e.getMessage(), e);
        }
        return object;
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public void setUnmarshaller(Unmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
    }

    public Object unmarshal(Reader reader, Class type) throws MarshallingException, IOException, ValidationException {
        Object object;
        try {
            object = this.unmarshaller.unmarshal(reader);
        }
        catch (MarshalException e) {
            LOG.warn((Object)("Unmarshal failed with exception: " + (Object)((Object)e)));
            throw new MarshallingException(e.getMessage(), e);
        }
        catch (org.exolab.castor.xml.ValidationException e) {
            LOG.warn((Object)("Unmarshal failed with exception: " + (Object)((Object)e)));
            throw new ValidationException(e.getMessage(), e);
        }
        return object;
    }
}

