/*
 * Decompiled with CFR 0.152.
 */
package org.castor.spring.xml;

import org.exolab.castor.util.DefaultObjectFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringObjectFactory
extends DefaultObjectFactory
implements ApplicationContextAware {
    private ApplicationContext context;

    public Object createInstance(Class type, Class[] argTypes, Object[] args) throws IllegalAccessException, InstantiationException {
        String[] beanNames;
        Object bean = null;
        if (this.context != null && (beanNames = this.context.getBeanNamesForType(type)) != null && beanNames.length != 0) {
            if (beanNames.length == 1) {
                if (!this.context.isSingleton(beanNames[0])) {
                    bean = this.context.getBean(beanNames[0], type);
                }
            } else {
                int i = 0;
                while (i < beanNames.length) {
                    if (beanNames[i].equals(type.getName()) || beanNames[i].equals(this.getSimpleName(type))) {
                        if (this.context.isSingleton(beanNames[i])) break;
                        bean = this.context.getBean(beanNames[i], type);
                        break;
                    }
                    ++i;
                }
            }
        }
        if (bean == null) {
            bean = super.createInstance(type, argTypes, args);
        }
        return bean;
    }

    private String getSimpleName(Class type) {
        String qualifiedName = type.getName();
        return qualifiedName.substring(qualifiedName.lastIndexOf(46));
    }

    public void setApplicationContext(ApplicationContext context) {
        this.context = context;
    }
}

