/*
 * Decompiled with CFR 0.152.
 */
package org.castor.spring.xml;

import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.XMLContext;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.xml.sax.InputSource;

public class XMLContextFactoryBean
implements FactoryBean,
InitializingBean {
    private static final Log LOG = LogFactory.getLog(XMLContextFactoryBean.class);
    private Properties castorProperties = new Properties();
    private List mappingLocations = new LinkedList();
    private XMLContext xmlContext;
    private List classes = new LinkedList();
    private List packages = new LinkedList();

    public void afterPropertiesSet() throws Exception {
        this.xmlContext = new XMLContext();
        this.classes.isEmpty();
        if (!this.packages.isEmpty()) {
            this.xmlContext.addPackages((String[])this.packages.toArray());
        }
        if (!this.mappingLocations.isEmpty()) {
            String mappingLocation = null;
            Iterator iter = this.mappingLocations.iterator();
            try {
                Mapping mapping = new Mapping();
                while (iter.hasNext()) {
                    mappingLocation = (String)iter.next();
                    URL mappingResource = this.getClass().getClassLoader().getResource(mappingLocation);
                    mapping.loadMapping(new InputSource(mappingResource.openStream()));
                }
                this.xmlContext.addMapping(mapping);
            }
            catch (MappingException e) {
                LOG.error((Object)("Problem locating/loading Castor mapping file from location " + mappingLocation), (Throwable)e);
                throw e;
            }
        }
        if (!this.castorProperties.isEmpty()) {
            Set<Map.Entry<Object, Object>> entries = this.castorProperties.entrySet();
            for (Map.Entry<Object, Object> entry : entries) {
                this.xmlContext.setProperty((String)entry.getKey(), entry.getValue());
            }
        }
    }

    public Object getObject() throws Exception {
        return this.xmlContext;
    }

    public Class getObjectType() {
        if (this.xmlContext == null) {
            return XMLContext.class;
        }
        return this.xmlContext.getClass();
    }

    public boolean isSingleton() {
        return true;
    }

    public void setCastorProperties(Properties castorProperties) {
        this.castorProperties.putAll((Map<?, ?>)castorProperties);
    }

    public void setMappingLocations(List mappingLocations) {
        this.mappingLocations.addAll(mappingLocations);
    }

    public void setClasses(List classes) {
        this.classes.addAll(classes);
    }

    public void setPackages(List packages) {
        this.packages.addAll(packages);
    }
}

