/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.fitnesseweb.proxy;

import fit.Counts;
import fit.Fixture;
import fit.Parse;
import fit.exception.FitParseException;
import fitnesse.components.CommandLine;
import fitnesse.components.FitProtocol;
import fitnesse.util.StreamReader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class ProxyFitServer {
    private String input;
    private Parse tables;
    private Fixture fixture = new Fixture();
    private Counts counts = new Counts();
    private Socket serverSocket;
    private OutputStream serverSocketOutput;
    private StreamReader serverSocketReader;
    private OutputStream remoteSocketOutput;
    private StreamReader remoteSocketReader;
    private boolean verbose = false;
    private String host;
    private int port;
    private int remotePort = 7777;
    private int socketToken;

    public ProxyFitServer(String host, int port, int remotePort, boolean verbose) {
        this.host = host;
        this.port = port;
        this.remotePort = remotePort;
        this.verbose = verbose;
    }

    public ProxyFitServer() {
    }

    public static void main(String[] argv) throws Exception {
        ProxyFitServer fitServer = new ProxyFitServer();
        fitServer.run(argv);
        System.exit(fitServer.exitCode());
    }

    public void run(String[] argv) throws Exception {
        this.args(argv);
        this.establishConnection();
        this.validateConnection();
        this.process();
        this.closeConnection();
        this.exit();
    }

    public void closeConnection() throws IOException {
        this.serverSocket.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() throws Exception {
        Socket webSocket = new Socket(this.host, this.remotePort);
        try {
            int size;
            this.remoteSocketOutput = new BufferedOutputStream(webSocket.getOutputStream());
            this.remoteSocketReader = new StreamReader((InputStream)new BufferedInputStream(webSocket.getInputStream()));
            FitProtocol.writeSize((int)0, (OutputStream)this.remoteSocketOutput);
            while ((size = FitProtocol.readSize((StreamReader)this.serverSocketReader)) != 0) {
                try {
                    String document = FitProtocol.readDocument((StreamReader)this.serverSocketReader, (int)size);
                    FitProtocol.writeData((String)document, (OutputStream)this.remoteSocketOutput);
                    this.forwardResponse();
                }
                catch (FitParseException e) {
                    this.exception((Exception)((Object)e));
                }
                catch (IOException e) {
                    this.exception(e);
                }
            }
            FitProtocol.writeSize((int)0, (OutputStream)this.remoteSocketOutput);
            this.print("completion signal recieved\n");
        }
        catch (Exception e) {
            this.exception(e);
        }
        finally {
            try {
                webSocket.close();
            }
            catch (IOException e) {
                this.exception(e);
            }
        }
    }

    public void forwardResponse() throws Exception {
        int remoteSize;
        while ((remoteSize = FitProtocol.readSize((StreamReader)this.remoteSocketReader)) != 0) {
            String remoteDocument = FitProtocol.readDocument((StreamReader)this.remoteSocketReader, (int)remoteSize);
            FitProtocol.writeData((String)remoteDocument, (OutputStream)this.serverSocketOutput);
        }
        Counts remoteCounts = FitProtocol.readCounts((StreamReader)this.remoteSocketReader);
        FitProtocol.writeCounts((Counts)remoteCounts, (OutputStream)this.serverSocketOutput);
    }

    public void args(String[] argv) {
        CommandLine commandLine = new CommandLine("[-v] remote-port host port socketToken");
        if (commandLine.parse(argv)) {
            this.host = commandLine.getArgument("host");
            this.port = Integer.parseInt(commandLine.getArgument("port"));
            this.remotePort = Integer.parseInt(commandLine.getArgument("remote-port"));
            this.socketToken = Integer.parseInt(commandLine.getArgument("socketToken"));
            this.verbose = commandLine.hasOption("v");
        } else {
            this.usage();
        }
    }

    private void usage() {
        System.out.println("usage: java fit.FitServer [-v] remote-port host port socketTicket");
        System.out.println("\t-v\tverbose");
    }

    protected void exception(Exception e) {
        this.print("Exception occurred!\n");
        this.print("\t" + e.getMessage() + "\n");
        this.tables = new Parse("span", "Exception occurred: ", null, null);
        this.fixture.exception(this.tables, (Throwable)e);
        ++this.counts.exceptions;
        this.fixture.listener.tableFinished(this.tables);
        this.fixture.listener.tablesFinished(this.counts);
    }

    public void exit() throws Exception {
        this.print("exiting\n");
        this.print("\tend results: " + this.counts.toString() + "\n");
    }

    public int exitCode() {
        return this.counts.wrong + this.counts.exceptions;
    }

    public void establishConnection() throws Exception {
        this.establishConnection(this.makeHttpRequest());
    }

    public void establishConnection(String httpRequest) throws Exception {
        this.serverSocket = new Socket(this.host, this.port);
        this.serverSocketOutput = new BufferedOutputStream(this.serverSocket.getOutputStream());
        this.serverSocketReader = new StreamReader((InputStream)new BufferedInputStream(this.serverSocket.getInputStream()));
        byte[] bytes = httpRequest.getBytes("UTF-8");
        this.serverSocketOutput.write(bytes);
        this.serverSocketOutput.flush();
        this.print("http request sent\n");
    }

    private String makeHttpRequest() {
        return "GET /?responder=socketCatcher&ticket=" + this.socketToken + " HTTP/1.1\r\n\r\n";
    }

    public void validateConnection() throws Exception {
        this.print("validating connection...");
        int statusSize = FitProtocol.readSize((StreamReader)this.serverSocketReader);
        if (statusSize == 0) {
            this.print("...ok\n");
        } else {
            String errorMessage = FitProtocol.readDocument((StreamReader)this.serverSocketReader, (int)statusSize);
            this.print("...failed bacuase: " + errorMessage + "\n");
            System.out.println("An error occured while connecting to client.");
            System.out.println(errorMessage);
        }
    }

    public String readDocument() throws Exception {
        int size = FitProtocol.readSize((StreamReader)this.serverSocketReader);
        return FitProtocol.readDocument((StreamReader)this.serverSocketReader, (int)size);
    }

    public Counts getCounts() {
        return this.counts;
    }

    private void print(String message) {
        if (this.verbose) {
            System.out.print(message);
        }
    }
}

