/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.fitnesseweb.proxy;

import fit.Counts;
import fitnesse.components.CommandLine;
import fitnesse.responders.run.TestSummary;
import fitnesse.runner.CachingResultFormatter;
import fitnesse.runner.FormattingOption;
import fitnesse.runner.PageResult;
import fitnesse.runner.ResultHandler;
import fitnesse.runner.StandardResultHandler;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;
import java.util.List;
import org.codehaus.fitnesseweb.proxy.ProxyFitServer;
import org.codehaus.fitnesseweb.proxy.ProxyTestRunnerFixtureListener;

public class ProxyTestRunner {
    private String host;
    private int port;
    private int remotePort;
    private String pageName;
    private ProxyFitServer fitServer;
    public ProxyTestRunnerFixtureListener fixtureListener;
    public CachingResultFormatter handler;
    private PrintStream output;
    public List formatters = new LinkedList();
    private boolean debug;
    public boolean verbose;
    public boolean usingDownloadedPaths = true;

    public ProxyTestRunner() throws Exception {
        this(System.out);
    }

    public ProxyTestRunner(PrintStream output) throws Exception {
        this.output = output;
        this.handler = new CachingResultFormatter();
    }

    public static void main(String[] args) throws Exception {
        ProxyTestRunner runner = new ProxyTestRunner();
        runner.run(args);
        System.exit(runner.exitCode());
    }

    public void args(String[] args) throws Exception {
        CommandLine commandLine = new CommandLine("[-debug] [-v] [-results file] [-html file] [-xml file] [-nopath] host port pageName");
        if (!commandLine.parse(args)) {
            this.usage();
        }
        this.host = commandLine.getArgument("host");
        this.port = Integer.parseInt(commandLine.getArgument("port"));
        String remotePortTxt = System.getProperty("remote-port");
        if (remotePortTxt != null) {
            this.remotePort = Integer.parseInt(remotePortTxt);
        }
        this.pageName = commandLine.getArgument("pageName");
        if (commandLine.hasOption("debug")) {
            this.debug = true;
        }
        if (commandLine.hasOption("v")) {
            this.verbose = true;
            this.handler.addHandler((ResultHandler)new StandardResultHandler(this.output));
        }
        if (commandLine.hasOption("nopath")) {
            this.usingDownloadedPaths = false;
        }
        if (commandLine.hasOption("results")) {
            this.formatters.add(new FormattingOption("raw", commandLine.getOptionArgument("results", "file"), (OutputStream)this.output, this.host, this.port, this.pageName));
        }
        if (commandLine.hasOption("html")) {
            this.formatters.add(new FormattingOption("html", commandLine.getOptionArgument("html", "file"), (OutputStream)this.output, this.host, this.port, this.pageName));
        }
        if (commandLine.hasOption("xml")) {
            this.formatters.add(new FormattingOption("xml", commandLine.getOptionArgument("xml", "file"), (OutputStream)this.output, this.host, this.port, this.pageName));
        }
    }

    private void usage() {
        System.out.println("usage: java [-Dremote-port] fitnesse.runner.TestRunner [options] host port page-name");
        System.out.println("\t-v \tverbose: prints test progress to stdout");
        System.out.println("\t-results <filename|'stdout'>\tsave raw test results to a file or dump to standard output");
        System.out.println("\t-html <filename|'stdout'>\tformat results as HTML and save to a file or dump to standard output");
        System.out.println("\t-debug \tprints FitServer protocol actions to stdout");
        System.out.println("\t-nopath \tprevents downloaded path elements from being added to classpath");
    }

    public void run(String[] args) throws Exception {
        this.args(args);
        this.fitServer = new ProxyFitServer(this.host, this.port, this.remotePort, this.debug);
        this.fixtureListener = new ProxyTestRunnerFixtureListener(this);
        this.fitServer.establishConnection(this.makeHttpRequest());
        this.fitServer.validateConnection();
        if (this.usingDownloadedPaths) {
            this.processClasspathDocument();
        }
        this.fitServer.process();
        this.finalCount();
        this.fitServer.closeConnection();
        this.fitServer.exit();
        this.doFormatting();
        this.handler.cleanUp();
    }

    private void processClasspathDocument() throws Exception {
        String classpathItems = this.fitServer.readDocument();
        if (this.verbose) {
            this.output.println("Adding to classpath: " + classpathItems);
        }
        ProxyTestRunner.addItemsToClasspath(classpathItems);
    }

    private void finalCount() throws Exception {
        Counts counts = this.fitServer.getCounts();
        this.handler.acceptFinalCount(new TestSummary(counts.right, counts.wrong, counts.ignores, counts.exceptions));
    }

    public int exitCode() {
        return this.fitServer == null ? -1 : this.fitServer.exitCode();
    }

    public String makeHttpRequest() {
        String request = "GET /" + this.pageName + "?responder=fitClient";
        if (this.usingDownloadedPaths) {
            request = request + "&includePaths=yes";
        }
        return request + " HTTP/1.1\r\n\r\n";
    }

    public Counts getCounts() {
        return this.fitServer.getCounts();
    }

    public void acceptResults(PageResult results) throws Exception {
        this.handler.acceptResult(results);
    }

    public void doFormatting() throws Exception {
        for (Object formatter : this.formatters) {
            FormattingOption option = (FormattingOption)formatter;
            if (this.verbose) {
                this.output.println("Formatting as " + option.format + " to " + option.filename);
            }
            option.process(this.handler.getResultStream(), this.handler.getByteCount());
        }
    }

    public static void addItemsToClasspath(String classpathItems) throws Exception {
        String[] items;
        for (String item : items = classpathItems.split("[:;]")) {
            ProxyTestRunner.addUrlToClasspath(new File(item).toURL());
        }
    }

    public static void addUrlToClasspath(URL u) throws Exception {
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        Method method = sysclass.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        method.invoke((Object)sysloader, u);
    }
}

