/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.fitnesseweb.proxy;

import fit.Counts;
import fit.FitServer;
import fit.FixtureListener;
import fit.Parse;
import fitnesse.responders.run.TestSummary;
import fitnesse.runner.PageResult;
import org.codehaus.fitnesseweb.proxy.ProxyTestRunner;

public class ProxyTestRunnerFixtureListener
implements FixtureListener {
    public Counts counts = new Counts();
    private boolean atStartOfResult = true;
    private PageResult currentPageResult;
    private ProxyTestRunner runner;

    public ProxyTestRunnerFixtureListener(ProxyTestRunner runner) {
        this.runner = runner;
    }

    public void tableFinished(Parse table) {
        try {
            String data = new String(FitServer.readTable((Parse)table), "UTF-8");
            if (this.atStartOfResult) {
                int indexOfFirstLineBreak = data.indexOf("\n");
                String pageTitle = data.substring(0, indexOfFirstLineBreak);
                data = data.substring(indexOfFirstLineBreak + 1);
                this.currentPageResult = new PageResult(pageTitle);
                this.atStartOfResult = false;
            }
            this.currentPageResult.append(data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void tablesFinished(Counts count) {
        try {
            this.currentPageResult.setTestSummary(new TestSummary(this.counts.right, this.counts.wrong, this.counts.ignores, this.counts.exceptions));
            this.runner.acceptResults(this.currentPageResult);
            this.atStartOfResult = true;
            this.counts.tally(count);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

