/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gant.ant;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.codehaus.gant.GantBinding;
import org.codehaus.gant.GantBuilder;

public class Gant
extends Task {
    private String file = "build.gant";
    private final List<Definition> definitions = new ArrayList<Definition>();
    private final List<GantTarget> targets = new ArrayList<GantTarget>();

    public void setFile(String f) {
        this.file = f;
    }

    public void setTarget(String t) {
        GantTarget gt = new GantTarget();
        gt.setValue(t);
        this.targets.add(gt);
    }

    public GantTarget createGantTarget() {
        GantTarget gt = new GantTarget();
        this.targets.add(gt);
        return gt;
    }

    public Definition createDefinition() {
        Definition definition = new Definition();
        this.definitions.add(definition);
        return definition;
    }

    public void execute() throws BuildException {
        Project newProject = new Project();
        newProject.init();
        newProject.setBaseDir(this.getOwningTarget().getProject().getBaseDir());
        File gantFile = new File(newProject.getBaseDir(), this.file);
        if (!gantFile.exists()) {
            throw new BuildException("Gantfile does not exist.", this.getLocation());
        }
        GantBuilder ant = new GantBuilder(newProject);
        HashMap<String, String> environmentParameter = new HashMap<String, String>();
        environmentParameter.put("environment", "environment");
        PrintStream outSave = System.out;
        System.setOut(new PrintStream(new ByteArrayOutputStream()));
        ant.invokeMethod("property", new Object[]{environmentParameter});
        GantBinding binding = new GantBinding();
        binding.setVariable("ant", (Object)ant);
        binding.setVariable("Ant", (Object)ant);
        for (Definition definition : this.definitions) {
            HashMap<String, String> definitionParameter = new HashMap<String, String>();
            definitionParameter.put("name", definition.getName());
            definitionParameter.put("value", definition.getValue());
            ant.invokeMethod("property", new Object[]{definitionParameter});
        }
        System.setOut(outSave);
        gant.Gant gant = new gant.Gant(binding);
        gant.loadScript(gantFile);
        ArrayList<String> targetsAsStrings = new ArrayList<String>();
        for (GantTarget g : this.targets) {
            targetsAsStrings.add(g.getValue());
        }
        int returnCode = gant.processTargets(targetsAsStrings);
        if (returnCode != 0) {
            throw new BuildException("Gant execution failed with return code " + returnCode + '.', this.getLocation());
        }
    }

    public static final class GantTarget {
        private String value;

        public void setValue(String s) {
            this.value = s;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static final class Definition {
        private String name;
        private String value;

        public void setName(String s) {
            this.name = s;
        }

        public String getName() {
            return this.name;
        }

        public void setValue(String s) {
            this.value = s;
        }

        public String getValue() {
            return this.value;
        }
    }
}

