/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmaven.plugin;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.shared.model.fileset.FileSet;
import org.codehaus.gmaven.plugin.MojoSupport;

public class AddSourceMojo
extends MojoSupport {
    protected File defaultSourceDir;
    protected File defaultTestSourceDir;
    protected FileSet[] sources;
    protected FileSet[] testSources;

    public void doExecute() throws MojoExecutionException {
        String path;
        int i;
        int sourcesLength;
        if (this.sources != null && this.sources.length > 0) {
            sourcesLength = this.sources.length;
            for (i = 0; i < sourcesLength; ++i) {
                try {
                    path = new File(this.sources[i].getDirectory()).getCanonicalPath();
                    this.addSourcePath(path);
                    continue;
                }
                catch (IOException e) {
                    this.log.error("{}", (Throwable)e);
                }
            }
        } else {
            try {
                this.addSourcePath(this.defaultSourceDir.getCanonicalPath());
            }
            catch (IOException e) {
                this.log.error("{}", (Throwable)e);
            }
        }
        if (this.testSources != null) {
            sourcesLength = this.testSources.length;
            for (i = 0; i < sourcesLength; ++i) {
                try {
                    path = new File(this.testSources[i].getDirectory()).getCanonicalPath();
                    this.addTestSourcePath(path);
                    continue;
                }
                catch (IOException e) {
                    this.log.error("{}", (Throwable)e);
                }
            }
        } else {
            try {
                this.addTestSourcePath(this.defaultTestSourceDir.getCanonicalPath());
            }
            catch (IOException e) {
                this.log.error("{}", (Throwable)e);
            }
        }
    }

    protected void addSourcePath(String path) {
        if (!this.project.getCompileSourceRoots().contains(path)) {
            this.log.debug("Added Source directory: " + path);
            this.project.addCompileSourceRoot(path);
        }
    }

    protected void addTestSourcePath(String path) {
        if (!this.project.getTestCompileSourceRoots().contains(path)) {
            this.log.debug("Added Test Source directory: " + path);
            this.project.addTestCompileSourceRoot(path);
        }
    }
}

