/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.maven.gossip.model.filter;

import java.io.PrintStream;
import org.codehaus.groovy.maven.gossip.Event;
import org.codehaus.groovy.maven.gossip.config.ConfigurationException;
import org.codehaus.groovy.maven.gossip.model.Filter;
import org.codehaus.groovy.maven.gossip.model.render.Renderer;
import org.codehaus.groovy.maven.gossip.model.render.SimpleRenderer;

public class ConsoleWriter
extends Filter {
    public static final String OUT = "OUT";
    public static final String SYSOUT = "SYSOUT";
    public static final String SYSTEM_OUT = "SYSTEM.OUT";
    public static final String ERR = "ERR";
    public static final String SYSERR = "SYSERR";
    public static final String SYSTEM_ERR = "SYSTEM.ERR";
    private String name = "SYSTEM.OUT";
    private transient PrintStream stream;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ConsoleWriter() {
    }

    public ConsoleWriter(String name) {
        this.setName(name);
    }

    public String toString() {
        return "ConsoleWriter{name='" + this.name + '\'' + '}';
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        this.name = name;
    }

    private PrintStream getStream() {
        if (this.stream == null) {
            String tmp = this.name.toUpperCase();
            if (OUT.equals(tmp) || SYSOUT.equals(tmp) || SYSTEM_OUT.equals(tmp)) {
                this.stream = System.out;
            } else if (ERR.equals(tmp) || SYSERR.equals(tmp) || SYSTEM_ERR.equals(tmp)) {
                this.stream = System.err;
            } else {
                throw new ConfigurationException("Unknown stream name: " + this.name);
            }
        }
        return this.stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Filter.Result filter(Event event) {
        PrintStream out;
        if (!$assertionsDisabled && event == null) {
            throw new AssertionError();
        }
        Renderer renderer = this.getRenderer();
        if (renderer == null) {
            this.log.debug("Renderer not set; using default");
            renderer = new SimpleRenderer();
            this.setRenderer(renderer);
        }
        String text = renderer.render(event);
        PrintStream printStream = out = this.getStream();
        synchronized (printStream) {
            out.print(text);
            out.flush();
        }
        return STOP;
    }

    static {
        $assertionsDisabled = !ConsoleWriter.class.desiredAssertionStatus();
    }
}

