/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.maven.gossip;

import org.codehaus.groovy.maven.gossip.Level;
import org.slf4j.Logger;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;

public abstract class AbstractLogger
extends MarkerIgnoringBase
implements Logger {
    public final String name;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected AbstractLogger(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "[" + this.getName() + "]@" + System.identityHashCode((Object)this);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Logger that = (Logger)obj;
        return !(this.name == null ? that.getName() != null : !this.name.equals(that.getName()));
    }

    protected abstract boolean isEnabled(Level var1);

    protected abstract void doLog(Level var1, String var2, Throwable var3);

    private void log(Level level, String msg, Throwable cause) {
        if (this.isEnabled(level)) {
            this.doLog(level, msg, cause);
        }
    }

    private void log(Level level, String msg) {
        if (this.isEnabled(level)) {
            this.doLog(level, msg, null);
        }
    }

    private void log(Level level, String format, Object arg) {
        if (this.isEnabled(level)) {
            if (arg instanceof Throwable) {
                this.doLog(level, MessageFormatter.format((String)format, (Object)arg), (Throwable)arg);
            } else {
                this.doLog(level, MessageFormatter.format((String)format, (Object)arg), null);
            }
        }
    }

    private void log(Level level, String format, Object arg1, Object arg2) {
        if (this.isEnabled(level)) {
            if (arg2 instanceof Throwable) {
                this.doLog(level, MessageFormatter.format((String)format, (Object)arg1, (Object)arg2), (Throwable)arg2);
            } else {
                this.doLog(level, MessageFormatter.format((String)format, (Object)arg1, (Object)arg2), null);
            }
        }
    }

    private void log(Level level, String format, Object[] args) {
        if (this.isEnabled(level)) {
            if (args != null && args.length != 0 && args[args.length - 1] instanceof Throwable) {
                this.doLog(level, MessageFormatter.arrayFormat((String)format, (Object[])args), (Throwable)args[args.length - 1]);
            } else {
                this.doLog(level, MessageFormatter.arrayFormat((String)format, (Object[])args), null);
            }
        }
    }

    public boolean isTraceEnabled() {
        return this.isEnabled(Level.TRACE);
    }

    public void trace(String msg) {
        this.log(Level.TRACE, msg);
    }

    public void trace(String format, Object arg) {
        this.log(Level.TRACE, format, arg);
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.log(Level.TRACE, format, arg1, arg2);
    }

    public void trace(String format, Object[] args) {
        this.log(Level.TRACE, format, args);
    }

    public void trace(String msg, Throwable cause) {
        this.log(Level.TRACE, msg, cause);
    }

    public boolean isDebugEnabled() {
        return this.isEnabled(Level.DEBUG);
    }

    public void debug(String msg) {
        this.log(Level.DEBUG, msg);
    }

    public void debug(String format, Object arg) {
        this.log(Level.DEBUG, format, arg);
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.log(Level.DEBUG, format, arg1, arg2);
    }

    public void debug(String format, Object[] args) {
        this.log(Level.DEBUG, format, args);
    }

    public void debug(String msg, Throwable cause) {
        this.log(Level.DEBUG, msg, cause);
    }

    public boolean isInfoEnabled() {
        return this.isEnabled(Level.INFO);
    }

    public void info(String msg) {
        this.log(Level.INFO, msg);
    }

    public void info(String format, Object arg) {
        this.log(Level.INFO, format, arg);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.log(Level.INFO, format, arg1, arg2);
    }

    public void info(String format, Object[] args) {
        this.log(Level.INFO, format, args);
    }

    public void info(String msg, Throwable cause) {
        this.log(Level.INFO, msg, cause);
    }

    public boolean isWarnEnabled() {
        return this.isEnabled(Level.WARN);
    }

    public void warn(String msg) {
        this.log(Level.WARN, msg);
    }

    public void warn(String format, Object arg) {
        this.log(Level.WARN, format, arg);
    }

    public void warn(String format, Object[] args) {
        this.log(Level.WARN, format, args);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.log(Level.WARN, format, arg1, arg2);
    }

    public void warn(String msg, Throwable cause) {
        this.log(Level.WARN, msg, cause);
    }

    public boolean isErrorEnabled() {
        return this.isEnabled(Level.ERROR);
    }

    public void error(String msg) {
        this.log(Level.ERROR, msg);
    }

    public void error(String format, Object arg) {
        this.log(Level.ERROR, format, arg);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.log(Level.ERROR, format, arg1, arg2);
    }

    public void error(String format, Object[] args) {
        this.log(Level.ERROR, format, args);
    }

    public void error(String msg, Throwable cause) {
        this.log(Level.ERROR, msg, cause);
    }

    static {
        $assertionsDisabled = !AbstractLogger.class.desiredAssertionStatus();
    }
}

