/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URIBuilder
implements Cloneable {
    protected URI base;
    private final String ENC = "UTF-8";

    public URIBuilder(String url) throws URISyntaxException {
        this.base = new URI(url);
    }

    public URIBuilder(URL url) throws URISyntaxException {
        this.base = url.toURI();
    }

    public URIBuilder(URI uri) throws IllegalArgumentException {
        if (uri == null) {
            throw new IllegalArgumentException("uri cannot be null");
        }
        this.base = uri;
    }

    public static URI convertToURI(Object uri) throws URISyntaxException {
        if (uri instanceof URI) {
            return (URI)uri;
        }
        if (uri instanceof URL) {
            return ((URL)uri).toURI();
        }
        if (uri instanceof URIBuilder) {
            return ((URIBuilder)uri).toURI();
        }
        return new URI(uri.toString());
    }

    public URIBuilder setScheme(String scheme) throws URISyntaxException {
        this.base = new URI(scheme, this.base.getUserInfo(), this.base.getHost(), this.base.getPort(), this.base.getPath(), this.base.getQuery(), this.base.getFragment());
        return this;
    }

    public URIBuilder setPort(int port) throws URISyntaxException {
        this.base = new URI(this.base.getScheme(), this.base.getUserInfo(), this.base.getHost(), port, this.base.getPath(), this.base.getQuery(), this.base.getFragment());
        return this;
    }

    public URIBuilder setHost(String host) throws URISyntaxException {
        this.base = new URI(this.base.getScheme(), this.base.getUserInfo(), host, this.base.getPort(), this.base.getPath(), this.base.getQuery(), this.base.getFragment());
        return this;
    }

    public URIBuilder setPath(String path) throws URISyntaxException {
        this.base = this.base.resolve(new URI(null, null, path, this.base.getQuery(), this.base.getFragment()));
        return this;
    }

    public URIBuilder setQuery(Map<?, ?> params) throws URISyntaxException {
        if (params == null || params.size() < 1) {
            this.base = new URI(this.base.getScheme(), this.base.getUserInfo(), this.base.getHost(), this.base.getPort(), this.base.getPath(), null, this.base.getFragment());
        } else {
            ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>(params.size());
            StringBuilder sb = new StringBuilder();
            String path = this.base.getPath();
            if (path != null) {
                sb.append(path);
            }
            sb.append('?');
            for (Object key : params.keySet()) {
                Object val = params.get(key);
                pairs.add(new BasicNameValuePair(key.toString(), val != null ? val.toString() : ""));
            }
            sb.append(URLEncodedUtils.format(pairs, (String)"UTF-8"));
            String frag = this.base.getFragment();
            if (frag != null) {
                sb.append('#').append(frag);
            }
            this.base = this.base.resolve(sb.toString());
        }
        return this;
    }

    public Map<String, String> getQuery() {
        HashMap<String, String> params = new HashMap<String, String>();
        List pairs = URLEncodedUtils.parse((URI)this.base, (String)"UTF-8");
        for (NameValuePair pair : pairs) {
            params.put(pair.getName(), pair.getValue());
        }
        return params;
    }

    public boolean hasQueryParam(String name) {
        return this.getQuery().get(name) != null;
    }

    public URIBuilder removeQueryParam(String param) throws URISyntaxException {
        Map<String, String> params = this.getQuery();
        params.remove(param);
        this.setQuery(params);
        return this;
    }

    public URIBuilder addQueryParam(String param, Object value) throws URISyntaxException {
        Map<String, String> params = this.getQuery();
        if (value == null) {
            value = "";
        }
        params.put(param, value.toString());
        this.setQuery(params);
        return this;
    }

    public URIBuilder addQueryParams(Map<String, ?> params) throws URISyntaxException {
        Map<String, String> existing = this.getQuery();
        existing.putAll(params);
        this.setQuery(existing);
        return this;
    }

    public URIBuilder setFragment(String fragment) throws URISyntaxException {
        this.base = new URI(this.base.getScheme(), this.base.getUserInfo(), this.base.getHost(), this.base.getPort(), this.base.getPath(), this.base.getQuery(), fragment);
        return this;
    }

    public String toString() {
        return this.base.toString();
    }

    public URL toURL() throws MalformedURLException {
        return this.base.toURL();
    }

    public URI toURI() {
        return this.base;
    }

    public Object asType(Class<?> type) throws MalformedURLException {
        if (type == URI.class) {
            return this.toURI();
        }
        if (type == URL.class) {
            return this.toURL();
        }
        if (type == String.class) {
            return this.toString();
        }
        throw new ClassCastException("Cannot cast instance of URIBuilder to class " + type);
    }

    protected URIBuilder clone() {
        return new URIBuilder(this.base);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof URIBuilder)) {
            return false;
        }
        return this.base.equals(((URIBuilder)obj).toURI());
    }
}

