/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http;

import groovyx.net.http.HTTPBuilder;
import groovyx.net.http.URIBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;

public class AuthConfig {
    protected HTTPBuilder builder;

    public AuthConfig(HTTPBuilder builder) {
        this.builder = builder;
    }

    public void basic(String user, String pass) {
        URI uri = ((URIBuilder)this.builder.getUri()).toURI();
        if (uri == null) {
            throw new IllegalStateException("a default URI must be set");
        }
        this.basic(uri.getHost(), uri.getPort(), user, pass);
    }

    public void basic(String host, int port, String user, String pass) {
        this.builder.getClient().getCredentialsProvider().setCredentials(new AuthScope(host, port), (Credentials)new UsernamePasswordCredentials(user, pass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void certificate(String certURL, String password) throws GeneralSecurityException, IOException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        InputStream jksStream = new URL(certURL).openStream();
        try {
            keyStore.load(jksStream, password.toCharArray());
        }
        finally {
            jksStream.close();
        }
        SSLSocketFactory ssl = new SSLSocketFactory(keyStore, password);
        ssl.setHostnameVerifier(SSLSocketFactory.STRICT_HOSTNAME_VERIFIER);
        this.builder.getClient().getConnectionManager().getSchemeRegistry().register(new Scheme("https", (SocketFactory)ssl, 443));
    }
}

