/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http;

import groovy.lang.Closure;
import groovyx.net.http.AuthConfig;
import groovyx.net.http.ContentEncoding;
import groovyx.net.http.ContentEncodingRegistry;
import groovyx.net.http.ContentType;
import groovyx.net.http.EncoderRegistry;
import groovyx.net.http.HttpResponseDecorator;
import groovyx.net.http.HttpResponseException;
import groovyx.net.http.Method;
import groovyx.net.http.ParserRegistry;
import groovyx.net.http.ResponseParseException;
import groovyx.net.http.Status;
import groovyx.net.http.StringHashMap;
import groovyx.net.http.URIBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.MethodClosure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPBuilder {
    protected AbstractHttpClient client;
    protected URIBuilder defaultURI = null;
    protected AuthConfig auth = new AuthConfig(this);
    protected final Log log = LogFactory.getLog(this.getClass());
    protected Object defaultContentType = ContentType.ANY;
    protected Object defaultRequestContentType = null;
    protected final Map<Object, Closure> defaultResponseHandlers = new StringHashMap<Closure>(this.buildDefaultResponseHandlers());
    protected ContentEncodingRegistry contentEncodingHandler = new ContentEncodingRegistry();
    protected final Map<Object, Object> defaultRequestHeaders = new StringHashMap<Object>();
    protected EncoderRegistry encoders = new EncoderRegistry();
    protected ParserRegistry parsers = new ParserRegistry();

    public HTTPBuilder() {
        this.client = new DefaultHttpClient();
        this.setContentEncoding(new Object[]{ContentEncoding.Type.GZIP, ContentEncoding.Type.DEFLATE});
    }

    public HTTPBuilder(Object defaultURI) throws URISyntaxException {
        this();
        this.defaultURI = new URIBuilder(URIBuilder.convertToURI(defaultURI));
    }

    public HTTPBuilder(Object defaultURI, Object defaultContentType) throws URISyntaxException {
        this();
        this.defaultURI = new URIBuilder(URIBuilder.convertToURI(defaultURI));
        this.defaultContentType = defaultContentType;
    }

    public Object get(Map<String, ?> args) throws ClientProtocolException, IOException, URISyntaxException {
        return this.get(args, null);
    }

    public Object get(Map<String, ?> args, Closure responseClosure) throws ClientProtocolException, IOException, URISyntaxException {
        RequestConfigDelegate delegate = new RequestConfigDelegate((HttpRequestBase)new HttpGet(), this.defaultContentType, this.defaultRequestHeaders, this.defaultResponseHandlers);
        delegate.setPropertiesFromMap(args);
        if (responseClosure != null) {
            delegate.getResponse().put((Object)Status.SUCCESS, responseClosure);
        }
        return this.doRequest(delegate);
    }

    public Object post(Map<String, ?> args) throws ClientProtocolException, URISyntaxException, IOException {
        return this.post(args, null);
    }

    public Object post(Map<String, ?> args, Closure responseClosure) throws URISyntaxException, ClientProtocolException, IOException {
        RequestConfigDelegate delegate = new RequestConfigDelegate((HttpRequestBase)new HttpPost(), this.defaultContentType, this.defaultRequestHeaders, this.defaultResponseHandlers);
        delegate.setRequestContentType(ContentType.URLENC.toString());
        delegate.setPropertiesFromMap(args);
        if (responseClosure != null) {
            delegate.getResponse().put(Status.SUCCESS.toString(), responseClosure);
        }
        return this.doRequest(delegate);
    }

    public Object request(Method method, Closure configClosure) throws ClientProtocolException, IOException {
        return this.doRequest(this.defaultURI.toURI(), method, this.defaultContentType, configClosure);
    }

    public Object request(Method method, Object contentType, Closure configClosure) throws ClientProtocolException, IOException {
        return this.doRequest(this.defaultURI.toURI(), method, contentType, configClosure);
    }

    public Object request(Object uri, Method method, Object contentType, Closure configClosure) throws ClientProtocolException, IOException, URISyntaxException {
        return this.doRequest(URIBuilder.convertToURI(uri), method, contentType, configClosure);
    }

    protected Object doRequest(URI uri, Method method, Object contentType, Closure configClosure) throws ClientProtocolException, IOException {
        HttpRequestBase reqMethod;
        try {
            reqMethod = method.getRequestType().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        reqMethod.setURI(uri);
        RequestConfigDelegate delegate = new RequestConfigDelegate(reqMethod, contentType, this.defaultRequestHeaders, this.defaultResponseHandlers);
        configClosure.setDelegate((Object)delegate);
        configClosure.setResolveStrategy(1);
        configClosure.call((Object)reqMethod);
        return this.doRequest(delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doRequest(RequestConfigDelegate delegate) throws ClientProtocolException, IOException {
        HttpRequestBase reqMethod = delegate.getRequest();
        Object contentType = delegate.getContentType();
        String acceptContentTypes = contentType.toString();
        if (contentType instanceof ContentType) {
            acceptContentTypes = ((ContentType)((Object)contentType)).getAcceptHeader();
        }
        reqMethod.setHeader("Accept", acceptContentTypes);
        reqMethod.setURI(delegate.getUri().toURI());
        this.log.debug((Object)(reqMethod.getMethod() + " " + reqMethod.getURI()));
        Map<?, ?> headers = delegate.getHeaders();
        for (Object key : headers.keySet()) {
            Object val = headers.get(key);
            if (key == null) continue;
            if (val == null) {
                reqMethod.removeHeaders(key.toString());
                continue;
            }
            reqMethod.setHeader(key.toString(), val.toString());
        }
        HttpResponseDecorator resp = new HttpResponseDecorator(this.client.execute((HttpUriRequest)reqMethod), null);
        try {
            int status = resp.getStatusLine().getStatusCode();
            Closure responseClosure = delegate.findResponseHandler(status);
            this.log.debug((Object)("Response code: " + status + "; found handler: " + responseClosure));
            Object[] closureArgs = null;
            switch (responseClosure.getMaximumNumberOfParameters()) {
                case 1: {
                    closureArgs = new Object[]{resp};
                    break;
                }
                case 2: {
                    HttpEntity entity = resp.getEntity();
                    try {
                        if (entity == null || entity.getContentLength() == 0L) {
                            closureArgs = new Object[]{resp, null};
                            break;
                        }
                        closureArgs = new Object[]{resp, this.parseResponse(resp, contentType)};
                        break;
                    }
                    catch (Exception ex) {
                        Header h = entity.getContentType();
                        String respContentType = h != null ? h.getValue() : null;
                        this.log.warn((Object)("Error parsing '" + respContentType + "' response"), (Throwable)ex);
                        throw new ResponseParseException(resp, ex);
                    }
                }
                default: {
                    throw new IllegalArgumentException("Response closure must accept one or two parameters");
                }
            }
            Object returnVal = responseClosure.call(closureArgs);
            this.log.trace((Object)("response handler result: " + returnVal));
            Object object = returnVal;
            return object;
        }
        finally {
            HttpEntity entity = resp.getEntity();
            if (entity != null) {
                entity.consumeContent();
            }
        }
    }

    protected Object parseResponse(HttpResponse resp, Object contentType) throws HttpResponseException {
        if (resp.getEntity() == null) {
            this.log.debug((Object)"Response contains no entity.  Parsed data is null.");
            return null;
        }
        String responseContentType = contentType.toString();
        try {
            if (ContentType.ANY.toString().equals(responseContentType)) {
                responseContentType = ParserRegistry.getContentType(resp);
            }
        }
        catch (RuntimeException ex) {
            this.log.warn((Object)("Could not parse content-type: " + ex.getMessage()));
            responseContentType = ContentType.BINARY.toString();
        }
        Object parsedData = null;
        Closure parser = this.parsers.getAt(responseContentType);
        if (parser == null) {
            this.log.warn((Object)("No parser found for content-type: " + responseContentType));
        } else {
            this.log.debug((Object)("Parsing response as: " + responseContentType));
            parsedData = parser.call((Object)resp);
            if (parsedData == null) {
                this.log.warn((Object)"Parser returned null!");
            } else {
                this.log.debug((Object)("Parsed data to instance of: " + parsedData.getClass()));
            }
        }
        return parsedData;
    }

    protected Map<Object, Closure> buildDefaultResponseHandlers() {
        StringHashMap<Closure> map = new StringHashMap<Closure>();
        map.put(Status.SUCCESS, (Closure)new MethodClosure((Object)this, "defaultSuccessHandler"));
        map.put(Status.FAILURE, (Closure)new MethodClosure((Object)this, "defaultFailureHandler"));
        return map;
    }

    protected Object defaultSuccessHandler(HttpResponseDecorator resp, Object parsedData) throws ResponseParseException {
        try {
            if (parsedData instanceof InputStream) {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                DefaultGroovyMethods.leftShift((OutputStream)buffer, (InputStream)((InputStream)parsedData));
                parsedData = new ByteArrayInputStream(buffer.toByteArray());
            } else if (parsedData instanceof Reader) {
                StringWriter buffer = new StringWriter();
                DefaultGroovyMethods.leftShift((Writer)buffer, (Object)((Reader)parsedData));
                parsedData = new StringReader(buffer.toString());
            } else if (parsedData instanceof Closeable) {
                this.log.warn((Object)"Parsed data is streaming, but will be accessible after the network connection is closed.  Use at your own risk!");
            }
            return parsedData;
        }
        catch (IOException ex) {
            throw new ResponseParseException(resp, ex);
        }
    }

    protected void defaultFailureHandler(HttpResponseDecorator resp) throws HttpResponseException {
        throw new HttpResponseException(resp);
    }

    public Map<?, Closure> getHandler() {
        return this.defaultResponseHandlers;
    }

    public ParserRegistry getParser() {
        return this.parsers;
    }

    public EncoderRegistry getEncoder() {
        return this.encoders;
    }

    public void setContentType(Object ct) {
        this.defaultContentType = ct;
    }

    public Object getContentType() {
        return this.defaultContentType;
    }

    public void setContentEncoding(Object ... encodings) {
        this.contentEncodingHandler.setInterceptors(this.client, encodings);
    }

    public void setUri(Object uri) throws URISyntaxException {
        this.defaultURI = new URIBuilder(URIBuilder.convertToURI(uri));
    }

    public Object getUri() {
        return this.defaultURI;
    }

    public void setHeaders(Map<?, ?> headers) {
        this.defaultRequestHeaders.clear();
        if (headers == null) {
            return;
        }
        for (Object key : headers.keySet()) {
            Object val = headers.get(key);
            if (val == null) continue;
            this.defaultRequestHeaders.put(key.toString(), val.toString());
        }
    }

    public Map<?, ?> getHeaders() {
        return this.defaultRequestHeaders;
    }

    public AbstractHttpClient getClient() {
        return this.client;
    }

    public AuthConfig getAuth() {
        return this.auth;
    }

    public void setAuthConfig(AuthConfig ac) {
        this.auth = ac;
    }

    public void setEncoderRegistry(EncoderRegistry er) {
        this.encoders = er;
    }

    public void setParserRegistry(ParserRegistry pr) {
        this.parsers = pr;
    }

    public void setContentEncodingRegistry(ContentEncodingRegistry cer) {
        this.contentEncodingHandler = cer;
    }

    public void setProxy(String host, int port, String scheme) {
        this.getClient().getParams().setParameter("http.route.default-proxy", (Object)new HttpHost(host, port, scheme));
    }

    public void shutdown() {
        this.client.getConnectionManager().shutdown();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RequestConfigDelegate {
        private HttpRequestBase request;
        private Object contentType;
        private String requestContentType;
        private Map<Object, Closure> responseHandlers = new StringHashMap<Closure>();
        private URIBuilder uri;
        private Map<Object, Object> headers = new StringHashMap<Object>();

        public RequestConfigDelegate(HttpRequestBase request, Object contentType, Map<?, ?> defaultRequestHeaders, Map<?, Closure> defaultResponseHandlers) {
            if (request == null) {
                throw new IllegalArgumentException("Internal error - HttpRequest instance cannot be null");
            }
            this.request = request;
            this.headers.putAll(defaultRequestHeaders);
            this.contentType = contentType;
            if (HTTPBuilder.this.defaultRequestContentType != null) {
                this.requestContentType = HTTPBuilder.this.defaultRequestContentType.toString();
            }
            this.responseHandlers.putAll(defaultResponseHandlers);
            URI uri = request.getURI();
            if (uri != null) {
                this.uri = new URIBuilder(uri);
            }
        }

        public RequestConfigDelegate(Map<String, ?> args, HttpRequestBase request, Closure successHandler) throws URISyntaxException {
            this(request, hTTPBuilder.defaultContentType, hTTPBuilder.defaultRequestHeaders, hTTPBuilder.defaultResponseHandlers);
            if (successHandler != null) {
                this.responseHandlers.put(Status.SUCCESS.toString(), successHandler);
            }
            this.setPropertiesFromMap(args);
        }

        public URIBuilder getUri() {
            return this.uri;
        }

        public void setUri(Object uri) throws URISyntaxException {
            if (uri instanceof URIBuilder) {
                this.uri = (URIBuilder)uri;
            }
            this.uri = new URIBuilder(URIBuilder.convertToURI(uri));
        }

        protected HttpRequestBase getRequest() {
            return this.request;
        }

        protected Object getContentType() {
            return this.contentType;
        }

        protected void setContentType(Object ct) {
            this.contentType = ct == null ? HTTPBuilder.this.defaultContentType : ct;
        }

        protected String getRequestContentType() {
            if (this.requestContentType != null) {
                return this.requestContentType;
            }
            return this.getContentType().toString();
        }

        protected void setRequestContentType(String ct) {
            this.requestContentType = ct;
        }

        protected void setPropertiesFromMap(Map<String, ?> args) throws URISyntaxException {
            Object body;
            Object contentType;
            Object path;
            Map headers;
            if (args == null) {
                return;
            }
            if (args.get("url") != null) {
                throw new IllegalArgumentException("The 'url' parameter is deprecated; use 'uri' instead");
            }
            Object uri = args.get("uri");
            if (uri == null) {
                uri = HTTPBuilder.this.defaultURI;
            }
            if (uri == null) {
                throw new IllegalStateException("Default URI is null, and no 'uri' parameter was given");
            }
            this.uri = new URIBuilder(URIBuilder.convertToURI(uri));
            Map query = (Map)args.get("params");
            if (query != null) {
                HTTPBuilder.this.log.warn((Object)"'params' argument is deprecated; use 'query' instead.");
                this.uri.setQuery(query);
            }
            if ((query = (Map)args.get("query")) != null) {
                this.uri.setQuery(query);
            }
            if ((headers = (Map)args.get("headers")) != null) {
                this.getHeaders().putAll(headers);
            }
            if ((path = args.get("path")) != null) {
                this.uri.setPath(path.toString());
            }
            if ((contentType = args.get("contentType")) != null) {
                this.setContentType(contentType);
            }
            if ((contentType = args.get("requestContentType")) != null) {
                this.setRequestContentType(contentType.toString());
            }
            if ((body = args.get("body")) != null) {
                this.setBody(body);
            }
        }

        public void setHeaders(Map<?, ?> newHeaders) {
            this.headers.putAll(newHeaders);
        }

        public Map<?, ?> getHeaders() {
            return this.headers;
        }

        public void send(Object contentType, Object requestBody) {
            this.setRequestContentType(contentType.toString());
            this.setBody(requestBody);
        }

        public void setBody(Object body) {
            if (!(this.request instanceof HttpEntityEnclosingRequest)) {
                throw new IllegalArgumentException("Cannot set a request body for a " + this.request.getMethod() + " method");
            }
            Closure encoder = HTTPBuilder.this.encoders.getAt(this.getRequestContentType());
            HttpEntity entity = (HttpEntity)encoder.call(body);
            ((HttpEntityEnclosingRequest)this.request).setEntity(entity);
        }

        protected Closure findResponseHandler(int statusCode) {
            Closure handler = this.getResponse().get(Integer.toString(statusCode));
            if (handler == null) {
                handler = this.getResponse().get(Status.find(statusCode).toString());
            }
            return handler;
        }

        public Map<Object, Closure> getResponse() {
            return this.responseHandlers;
        }
    }
}

