/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http;

import groovyx.net.http.ContentType;
import groovyx.net.http.EncoderRegistry;
import groovyx.net.http.HttpResponseDecorator;
import groovyx.net.http.HttpResponseException;
import groovyx.net.http.ParserRegistry;
import groovyx.net.http.Status;
import groovyx.net.http.URIBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHeaderIterator;
import org.apache.http.message.BasicStatusLine;
import org.apache.http.params.HttpParams;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpURLClient {
    private Map<String, String> defaultHeaders = new HashMap<String, String>();
    private EncoderRegistry encoderRegistry = new EncoderRegistry();
    private ParserRegistry parserRegistry = new ParserRegistry();
    private Object contentType = ContentType.ANY;
    private Object requestContentType = null;
    private URIBuilder defaultURL = null;
    private boolean followRedirects = true;
    protected Log log = LogFactory.getLog(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponseDecorator request(Map<String, ?> args) throws URISyntaxException, MalformedURLException, IOException {
        String method;
        Object contentType;
        Object arg = (args = new HashMap(args)).remove("url");
        if (arg == null && this.defaultURL == null) {
            throw new IllegalStateException("Either the 'defaultURL' property must be set or a 'url' parameter must be passed to the request method.");
        }
        URIBuilder url = arg != null ? new URIBuilder(arg.toString()) : this.defaultURL.clone();
        arg = null;
        arg = args.remove("path");
        if (arg != null) {
            url.setPath(arg.toString());
        }
        arg = null;
        arg = args.remove("query");
        if (arg != null) {
            if (!(arg instanceof Map)) {
                throw new IllegalArgumentException("'query' must be a map");
            }
            url.setQuery((Map)arg);
        }
        HttpURLConnection conn = (HttpURLConnection)url.toURL().openConnection();
        conn.setInstanceFollowRedirects(this.followRedirects);
        arg = null;
        arg = args.remove("timeout");
        if (arg != null) {
            conn.setConnectTimeout(Integer.parseInt(arg.toString()));
        }
        arg = null;
        arg = args.remove("method");
        if (arg != null) {
            conn.setRequestMethod(arg.toString());
        }
        arg = null;
        arg = args.remove("contentType");
        Object object = contentType = arg != null ? arg : this.contentType;
        if (contentType instanceof ContentType) {
            conn.addRequestProperty("Accept", ((ContentType)((Object)contentType)).getAcceptHeader());
        }
        arg = null;
        arg = args.remove("requestContentType");
        String requestContentType = arg != null ? arg.toString() : (this.requestContentType != null ? this.requestContentType.toString() : (contentType != null ? contentType.toString() : null));
        for (String key : this.defaultHeaders.keySet()) {
            conn.addRequestProperty(key, this.defaultHeaders.get(key));
        }
        arg = null;
        arg = args.remove("auth");
        if (arg != null) {
            try {
                List vals = (List)arg;
                conn.addRequestProperty("Authorization", this.getBasicAuthHeader(vals.get(0).toString(), vals.get(1).toString()));
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Auth argument must be a list in the form [user,pass]");
            }
        }
        arg = null;
        arg = args.remove("headers");
        if (arg != null) {
            if (!(arg instanceof Map)) {
                throw new IllegalArgumentException("'headers' must be a map");
            }
            Map headers = (Map)arg;
            for (Object key : headers.keySet()) {
                conn.addRequestProperty(key.toString(), headers.get(key).toString());
            }
        }
        arg = null;
        arg = args.remove("body");
        if (arg != null) {
            conn.setDoOutput(true);
            HttpEntity body = (HttpEntity)this.encoderRegistry.getAt(requestContentType).call(arg);
            conn.addRequestProperty("Content-Type", requestContentType);
            try {
                DefaultGroovyMethods.leftShift((OutputStream)conn.getOutputStream(), (InputStream)body.getContent());
            }
            finally {
                conn.getOutputStream().close();
            }
        }
        if (args.size() > 0) {
            for (String k : args.keySet()) {
                this.log.warn((Object)("request() : Unkown named parameter '" + k + "'"));
            }
        }
        this.log.debug((Object)(conn.getRequestMethod() + " " + url));
        HttpURLResponseAdapter response = new HttpURLResponseAdapter(conn);
        if (ContentType.ANY.equals(contentType)) {
            contentType = conn.getContentType();
        }
        Object result = (method = conn.getRequestMethod()).equals("HEAD") || method.equals("OPTIONS") ? null : this.parserRegistry.getAt(contentType).call((Object)response);
        this.log.debug((Object)response.getStatusLine());
        HttpResponseDecorator decoratedResponse = new HttpResponseDecorator(response, result);
        if (this.log.isTraceEnabled()) {
            for (Header h : decoratedResponse.getHeaders()) {
                this.log.trace((Object)(" << " + h.getName() + " : " + h.getValue()));
            }
        }
        if (conn.getResponseCode() > 399) {
            throw new HttpResponseException(decoratedResponse);
        }
        return decoratedResponse;
    }

    private String getBasicAuthHeader(String user, String pass) throws UnsupportedEncodingException {
        return "Basic " + DefaultGroovyMethods.encodeBase64((byte[])(user + ":" + pass).getBytes("ISO-8859-1")).toString();
    }

    public void setBasicAuth(Object user, Object pass) throws UnsupportedEncodingException {
        if (user == null) {
            this.defaultHeaders.remove("Authorization");
        } else {
            this.defaultHeaders.put("Authorization", this.getBasicAuthHeader(user.toString(), pass.toString()));
        }
    }

    public void setFollowRedirects(boolean follow) {
        this.followRedirects = follow;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public Object getUrl() {
        return this.defaultURL;
    }

    public void setUrl(Object url) throws URISyntaxException {
        this.defaultURL = new URIBuilder(URIBuilder.convertToURI(url));
    }

    public Map<String, String> getHeaders() {
        return this.defaultHeaders;
    }

    public void setHeaders(Map<?, ?> headers) {
        this.defaultHeaders.clear();
        for (Object key : headers.keySet()) {
            Object val = headers.get(key);
            if (val == null) continue;
            this.defaultHeaders.put(key.toString(), val.toString());
        }
    }

    public EncoderRegistry getEncoders() {
        return this.encoderRegistry;
    }

    public void setEncoders(EncoderRegistry encoderRegistry) {
        this.encoderRegistry = encoderRegistry;
    }

    public ParserRegistry getParsers() {
        return this.parserRegistry;
    }

    public void setParsers(ParserRegistry parserRegistry) {
        this.parserRegistry = parserRegistry;
    }

    public Object getContentType() {
        return this.contentType;
    }

    public void setContentType(Object ct) {
        this.contentType = ct == null ? ContentType.ANY : ct;
    }

    public Object getRequestContentType() {
        return this.requestContentType;
    }

    public void setRequestContentType(Object requestContentType) {
        this.requestContentType = requestContentType;
    }

    private final class HttpURLResponseAdapter
    implements HttpResponse {
        HttpURLConnection conn;
        Header[] headers;

        HttpURLResponseAdapter(HttpURLConnection conn) {
            this.conn = conn;
        }

        public HttpEntity getEntity() {
            return new HttpEntity(){

                public void consumeContent() throws IOException {
                    HttpURLResponseAdapter.this.conn.getInputStream().close();
                }

                public InputStream getContent() throws IOException, IllegalStateException {
                    if (Status.find(HttpURLResponseAdapter.this.conn.getResponseCode()) == Status.FAILURE) {
                        return HttpURLResponseAdapter.this.conn.getErrorStream();
                    }
                    return HttpURLResponseAdapter.this.conn.getInputStream();
                }

                public Header getContentEncoding() {
                    return new BasicHeader("Content-Encoding", HttpURLResponseAdapter.this.conn.getContentEncoding());
                }

                public long getContentLength() {
                    return HttpURLResponseAdapter.this.conn.getContentLength();
                }

                public Header getContentType() {
                    return new BasicHeader("Content-Type", HttpURLResponseAdapter.this.conn.getContentType());
                }

                public boolean isChunked() {
                    String enc = HttpURLResponseAdapter.this.conn.getHeaderField("Transfer-Encoding");
                    return enc != null && enc.contains("chunked");
                }

                public boolean isRepeatable() {
                    return false;
                }

                public boolean isStreaming() {
                    return true;
                }

                public void writeTo(OutputStream out) throws IOException {
                    DefaultGroovyMethods.leftShift((OutputStream)out, (InputStream)HttpURLResponseAdapter.this.conn.getInputStream());
                }
            };
        }

        public Locale getLocale() {
            String val = this.conn.getHeaderField("Locale");
            return val != null ? new Locale(val) : Locale.getDefault();
        }

        public StatusLine getStatusLine() {
            try {
                return new BasicStatusLine(this.getProtocolVersion(), this.conn.getResponseCode(), this.conn.getResponseMessage());
            }
            catch (IOException ex) {
                throw new RuntimeException("Error reading status line", ex);
            }
        }

        public boolean containsHeader(String key) {
            return this.conn.getHeaderField(key) != null;
        }

        public Header[] getAllHeaders() {
            String key;
            int i;
            if (this.headers != null) {
                return this.headers;
            }
            ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
            int n = i = this.conn.getHeaderFieldKey(0) != null ? 0 : 1;
            while ((key = this.conn.getHeaderFieldKey(i)) != null) {
                headers.add(new BasicHeader(key, this.conn.getHeaderField(i++)));
            }
            this.headers = headers.toArray(new Header[headers.size()]);
            return this.headers;
        }

        public Header getFirstHeader(String key) {
            for (Header h : this.getAllHeaders()) {
                if (!h.getName().equals(key)) continue;
                return h;
            }
            return null;
        }

        public Header[] getHeaders(String key) {
            ArrayList<Header> headers = new ArrayList<Header>();
            for (Header h : this.getAllHeaders()) {
                if (!h.getName().equals(key)) continue;
                headers.add(h);
            }
            return headers.toArray(new Header[headers.size()]);
        }

        public Header getLastHeader(String key) {
            String val = this.conn.getHeaderField(key);
            return val != null ? new BasicHeader(key, val) : null;
        }

        public HttpParams getParams() {
            return null;
        }

        public ProtocolVersion getProtocolVersion() {
            return new ProtocolVersion("HTTP", 1, 1);
        }

        public HeaderIterator headerIterator() {
            return new BasicHeaderIterator(this.getAllHeaders(), null);
        }

        public HeaderIterator headerIterator(String key) {
            return new BasicHeaderIterator(this.getHeaders(key), key);
        }

        public void setEntity(HttpEntity entity) {
        }

        public void setLocale(Locale l) {
        }

        public void setReasonPhrase(String phrase) {
        }

        public void setStatusCode(int code) {
        }

        public void setStatusLine(StatusLine line) {
        }

        public void setStatusLine(ProtocolVersion v, int code) {
        }

        public void setStatusLine(ProtocolVersion arg0, int arg1, String arg2) {
        }

        public void addHeader(Header arg0) {
        }

        public void addHeader(String arg0, String arg1) {
        }

        public void removeHeader(Header arg0) {
        }

        public void removeHeaders(String arg0) {
        }

        public void setHeader(Header arg0) {
        }

        public void setHeader(String arg0, String arg1) {
        }

        public void setHeaders(Header[] arg0) {
        }

        public void setParams(HttpParams arg0) {
        }
    }
}

