/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http;

import groovyx.net.http.HTTPBuilder;
import groovyx.net.http.URIBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.commonshttp.CommonsHttpOAuthConsumer;
import oauth.signpost.exception.OAuthException;
import org.apache.http.Header;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.protocol.HttpContext;

public class AuthConfig {
    protected HTTPBuilder builder;

    public AuthConfig(HTTPBuilder builder) {
        this.builder = builder;
    }

    public void basic(String user, String pass) {
        URI uri = ((URIBuilder)this.builder.getUri()).toURI();
        if (uri == null) {
            throw new IllegalStateException("a default URI must be set");
        }
        this.basic(uri.getHost(), uri.getPort(), user, pass);
    }

    public void basic(String host, int port, String user, String pass) {
        this.builder.getClient().getCredentialsProvider().setCredentials(new AuthScope(host, port), (Credentials)new UsernamePasswordCredentials(user, pass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void certificate(String certURL, String password) throws GeneralSecurityException, IOException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        InputStream jksStream = new URL(certURL).openStream();
        try {
            keyStore.load(jksStream, password.toCharArray());
        }
        finally {
            jksStream.close();
        }
        SSLSocketFactory ssl = new SSLSocketFactory(keyStore, password);
        ssl.setHostnameVerifier(SSLSocketFactory.STRICT_HOSTNAME_VERIFIER);
        this.builder.getClient().getConnectionManager().getSchemeRegistry().register(new Scheme("https", (SocketFactory)ssl, 443));
    }

    public void oauth(String consumerKey, String consumerSecret, String accessToken, String secretToken) {
        this.builder.client.removeRequestInterceptorByClass(OAuthSigner.class);
        if (consumerKey != null) {
            this.builder.client.addRequestInterceptor((HttpRequestInterceptor)new OAuthSigner(consumerKey, consumerSecret, accessToken, secretToken));
        }
    }

    static class OAuthSigner
    implements HttpRequestInterceptor {
        protected OAuthConsumer oauth;

        public OAuthSigner(String consumerKey, String consumerSecret, String accessToken, String secretToken) {
            this.oauth = new CommonsHttpOAuthConsumer(consumerKey, consumerSecret);
            this.oauth.setTokenWithSecret(accessToken, secretToken);
        }

        public void process(HttpRequest request, HttpContext ctx) throws HttpException, IOException {
            try {
                HttpHost host = (HttpHost)ctx.getAttribute("http.target_host");
                URI requestURI = new URI(host.toURI()).resolve(request.getRequestLine().getUri());
                OAuthRequestAdapter oAuthRequest = new OAuthRequestAdapter(request, requestURI);
                this.oauth.sign((oauth.signpost.http.HttpRequest)oAuthRequest);
            }
            catch (URISyntaxException ex) {
                throw new HttpException("Error rebuilding request URI", (Throwable)ex);
            }
            catch (OAuthException e) {
                throw new HttpException("OAuth signing error", (Throwable)e);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class OAuthRequestAdapter
        implements oauth.signpost.http.HttpRequest {
            final HttpRequest request;
            final URI requestURI;

            OAuthRequestAdapter(HttpRequest request, URI requestURI) {
                this.request = request;
                this.requestURI = requestURI;
            }

            public String getRequestUrl() {
                return this.requestURI.toString();
            }

            public void setRequestUrl(String url) {
            }

            public Map<String, String> getAllHeaders() {
                HashMap<String, String> headers = new HashMap<String, String>();
                for (Header h : this.request.getAllHeaders()) {
                    headers.put(h.getName(), h.getValue());
                }
                return headers;
            }

            public String getContentType() {
                try {
                    return this.request.getFirstHeader("content-type").getValue();
                }
                catch (Exception ex) {
                    return null;
                }
            }

            public String getHeader(String name) {
                Header h = this.request.getFirstHeader(name);
                return h != null ? h.getValue() : null;
            }

            public InputStream getMessagePayload() throws IOException {
                if (this.request instanceof HttpEntityEnclosingRequest) {
                    return ((HttpEntityEnclosingRequest)this.request).getEntity().getContent();
                }
                return null;
            }

            public String getMethod() {
                return this.request.getRequestLine().getMethod();
            }

            public void setHeader(String key, String val) {
                this.request.setHeader(key, val);
            }

            public Object unwrap() {
                return this.request;
            }
        }
    }
}

