/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.ws;

import groovyx.net.ws.AbstractCXFWSClient;
import groovyx.net.ws.cxf.BasicAuthenticationHelper;
import groovyx.net.ws.cxf.ConnectionTimeoutHelper;
import groovyx.net.ws.cxf.MtomHelper;
import groovyx.net.ws.cxf.ProxyHelper;
import groovyx.net.ws.cxf.SSLHelper;
import groovyx.net.ws.cxf.SoapHelper;
import groovyx.net.ws.cxf.SoapVersion;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSClient
extends AbstractCXFWSClient {
    private static final String HTTPS = "https";
    protected URL url;
    protected ClassLoader classloader;

    public WSClient(String wsdlLocation, ClassLoader classloader) {
        try {
            this.url = new URL(wsdlLocation);
            this.classloader = classloader;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("URL is not valid.", e);
        }
        this.sslHelper = new SSLHelper();
        this.proxyHelper = new ProxyHelper();
        this.basicAuthHelper = new BasicAuthenticationHelper();
        this.mtomHelper = new MtomHelper();
        this.connectionTimeoutHelper = new ConnectionTimeoutHelper();
        this.soapHelper = new SoapHelper();
    }

    public WSClient(String wsdlLocation, ClassLoader classloader, SoapVersion soapVersion) {
        this(wsdlLocation, classloader);
        this.soapHelper.setPreferredSoapVersion(soapVersion);
    }

    private void configureHttpClientPolicy(HTTPConduit conduit) {
        HTTPClientPolicy httpClientPolicy = conduit.getClient();
        httpClientPolicy.setAllowChunking(false);
        conduit.setClient(httpClientPolicy);
    }

    @Override
    public void initialize() {
        URL url = this.url;
        this.proxyHelper.initialize();
        this.basicAuthHelper.initialize();
        boolean isSSLProtocol = HTTPS.equals(this.url.getProtocol());
        if (isSSLProtocol) {
            this.sslHelper.initialize();
            url = this.sslHelper.getLocalWsdlUrl(this.url);
        }
        this.client = this.createClient(url, this.classloader);
        this.soapHelper.enable(this.client);
        this.proxyHelper.enable(this.client);
        this.basicAuthHelper.enable(this.client);
        if (isSSLProtocol) {
            this.sslHelper.enable(this.client);
        }
        this.mtomHelper.enable(this.client);
        HTTPConduit conduit = (HTTPConduit)this.client.getConduit();
        this.configureHttpClientPolicy(conduit);
    }

    public void setProxyProperties(Map<String, String> proxyProperties) {
        this.proxyHelper.setProperties(proxyProperties);
    }

    public void setSSLProperties(Map<String, String> sslProperties) {
        this.sslHelper.setProperties(sslProperties);
    }

    public void setBasicAuthentication(String name, String password) {
        this.basicAuthHelper.setBasicAuthentication(name, password);
    }

    public void setMtom(boolean isMtom) {
        this.mtomHelper.setMtom(isMtom);
    }

    public void setConnectionTimeout(long timeout) {
        this.connectionTimeoutHelper.setConnectionTimeout(timeout);
    }

    public void setPreferredSoapVersion(SoapVersion soapVersion) {
        this.soapHelper.setPreferredSoapVersion(soapVersion);
    }
}

