/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.ws.cxf;

import groovyx.net.ws.cxf.AbstractSettingHelper;
import groovyx.net.ws.cxf.SoapVersion;
import org.apache.cxf.binding.soap.model.SoapBindingInfo;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.ServiceInfo;

public class SoapHelper
extends AbstractSettingHelper {
    private SoapBindingInfo soapBindingInfo;
    private SoapVersion preferredSoapVersion = SoapVersion.SOAP_1_1;

    protected void setDefaultProperties() {
        this.preferredSoapVersion = SoapVersion.SOAP_1_1;
    }

    public void setPreferredSoapVersion(SoapVersion soapVersion) {
        this.preferredSoapVersion = soapVersion;
    }

    public SoapBindingInfo getBinding() {
        return this.soapBindingInfo;
    }

    protected void configureClientParameters(Client client) {
        SoapBindingInfo sbi = null;
        for (ServiceInfo sInfo : client.getEndpoint().getService().getServiceInfos()) {
            for (BindingInfo bInfo : sInfo.getBindings()) {
                if (!(bInfo instanceof SoapBindingInfo) || (sbi = (SoapBindingInfo)bInfo).getSoapVersion().getVersion() != this.preferredSoapVersion.value()) continue;
                this.soapBindingInfo = sbi;
            }
        }
        if (this.soapBindingInfo == null) {
            this.soapBindingInfo = sbi;
        }
        assert (this.soapBindingInfo != null);
    }
}

