/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.ws;

import groovy.lang.GroovyObjectSupport;
import groovyx.net.ws.IWSClient;
import groovyx.net.ws.cxf.BasicAuthenticationHelper;
import groovyx.net.ws.cxf.ConnectionTimeoutHelper;
import groovyx.net.ws.cxf.MtomHelper;
import groovyx.net.ws.cxf.ProxyHelper;
import groovyx.net.ws.cxf.SSLHelper;
import groovyx.net.ws.cxf.SoapHelper;
import groovyx.net.ws.exceptions.InvokeException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.dynamic.DynamicClientFactory;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.codehaus.groovy.runtime.InvokerHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCXFWSClient
extends GroovyObjectSupport
implements IWSClient<Client> {
    protected Client client;
    protected SSLHelper sslHelper;
    protected ProxyHelper proxyHelper;
    protected BasicAuthenticationHelper basicAuthHelper;
    protected ConnectionTimeoutHelper connectionTimeoutHelper;
    protected MtomHelper mtomHelper;
    protected SoapHelper soapHelper;

    protected Logger getLogger() {
        return LogUtils.getL7dLogger(this.getClass());
    }

    @Override
    public Object invokeMethod(String methodName, Object args) {
        Object[] params = InvokerHelper.asArray((Object)args);
        try {
            Object[] response;
            BindingOperationInfo operationToBeInvoked = null;
            this.getLogger().finest("Using SOAP version: " + this.soapHelper.getBinding().getSoapVersion().getVersion());
            for (BindingOperationInfo operation : this.soapHelper.getBinding().getOperations()) {
                QName qname = operation.getName();
                this.getLogger().finest("available method: " + qname);
                if (!methodName.equals(qname.getLocalPart())) continue;
                operationToBeInvoked = operation;
            }
            if (operationToBeInvoked == null) {
                throw new NoSuchMethodException(methodName);
            }
            this.getLogger().finest("Invoke, operation info: " + operationToBeInvoked + ", objs: " + params.toString());
            BindingMessageInfo inputMessageInfo = !operationToBeInvoked.isUnwrapped() ? operationToBeInvoked.getWrappedOperation().getInput() : operationToBeInvoked.getUnwrappedOperation().getInput();
            List parts = inputMessageInfo.getMessageParts();
            if (parts.isEmpty()) {
                this.getLogger().finest("parts is empty. No message !");
            } else {
                MessagePartInfo partInfo = (MessagePartInfo)parts.get(0);
                Class param1Class = partInfo.getTypeClass();
                this.getLogger().finest("param1 is of Type: " + param1Class.getCanonicalName());
            }
            this.getLogger().finest("There are " + params.length + " parameters to the call");
            if (params.length > 0) {
                this.getLogger().finest("First parameter is of type: " + params[0].getClass().getCanonicalName());
            }
            if (operationToBeInvoked.isUnwrappedCapable()) {
                operationToBeInvoked = operationToBeInvoked.getUnwrappedOperation();
                this.getLogger().finest("The operation <" + operationToBeInvoked + "> is Unwrap capable");
                response = this.client.invoke(operationToBeInvoked, params);
            } else {
                operationToBeInvoked = operationToBeInvoked.getWrappedOperation();
                this.getLogger().finest("The operation <" + operationToBeInvoked + "> is NOT Unwrap capable");
                response = this.client.invoke(operationToBeInvoked, params);
            }
            if (response != null) {
                this.getLogger().finest("Response: " + response.toString() + " [" + response.getClass().getName() + "]");
                return this.parseResponse(response);
            }
            return null;
        }
        catch (Exception e) {
            this.getLogger().finest("Could not invoke method." + e);
            throw new InvokeException(e);
        }
    }

    protected Object parseResponse(Object[] response) {
        Object toReturn = response.length == 0 ? response : (response.length == 1 ? response[0] : new ArrayList<Object>(Arrays.asList(response)));
        return toReturn;
    }

    public Object create(String classname) throws IllegalAccessException {
        if (classname == null) {
            throw new IllegalArgumentException("Must provide the class name");
        }
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(classname);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        assert (clazz != null);
        if (clazz.isEnum()) {
            return clazz;
        }
        Object obj = null;
        try {
            obj = clazz.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        return obj;
    }

    public void changeEndpointAddress(URL newUrl) {
        this.client.getRequestContext().put("javax.xml.ws.service.endpoint.address", newUrl.toExternalForm());
    }

    @Override
    public Client createClient(Object ... args) {
        if (args[0] instanceof URL) {
            URL url = (URL)args[0];
            if (args.length == 2) {
                return DynamicClientFactory.newInstance().createClient(url.toExternalForm(), (ClassLoader)args[1]);
            }
            throw new IllegalArgumentException("Parameters are not set properly.");
        }
        return null;
    }
}

