/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.ws.cxf;

import groovyx.net.ws.cxf.AbstractSettingHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManagerFactory;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.configuration.security.FiltersType;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.transport.http.HTTPConduit;

public class SSLHelper
extends AbstractSettingHelper {
    private TrustManagerFactory trustStoreManager;
    private KeyManagerFactory keyStoreManager;

    protected void setDefaultProperties() {
        String[] candidatePassword;
        this.properties = new HashMap();
        String def_truststore = System.getProperty("java.home") + "/lib/security/cacerts";
        String def_truststore_pass = null;
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance("JKS");
        }
        catch (KeyStoreException e1) {
            e1.printStackTrace();
        }
        assert (keyStore != null);
        for (String it : candidatePassword = new String[]{"changeit", "changeme"}) {
            if (def_truststore_pass != null) continue;
            try {
                File thetruststore = new File(def_truststore);
                keyStore.load(new FileInputStream(thetruststore), it.toCharArray());
                def_truststore_pass = it;
            }
            catch (CertificateException e) {
                e.printStackTrace();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        assert (def_truststore_pass != null);
        this.properties.put("https.keystore", System.getProperty("https.keystore", ""));
        this.properties.put("https.keystore.pass", System.getProperty("https.keystore.pass", ""));
        this.properties.put("https.truststore", System.getProperty("https.truststore", def_truststore));
        this.properties.put("https.truststore.pass", System.getProperty("https.truststore.pass", def_truststore_pass));
    }

    public void initialize() {
        if (!this.isConfigured()) {
            this.setDefaultProperties();
        }
        this.configureStoreManager();
    }

    private void configureStoreManager() {
        String strKeystore = (String)this.properties.get("https.keystore");
        String strKsPass = (String)this.properties.get("https.keystore.pass");
        String strTruststore = (String)this.properties.get("https.truststore");
        String strTsPass = (String)this.properties.get("https.truststore.pass");
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance("JKS");
        }
        catch (KeyStoreException e1) {
            e1.printStackTrace();
        }
        assert (keyStore != null);
        try {
            if ("".compareTo(strKeystore) < 0) {
                File thekeystore = new File(strKeystore);
                keyStore.load(new FileInputStream(thekeystore), strKsPass.toCharArray());
                this.keyStoreManager = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                this.keyStoreManager.init(keyStore, strKsPass.toCharArray());
            }
            if ("".compareTo(strTruststore) < 0) {
                File thetruststore = new File(strTruststore);
                keyStore.load(new FileInputStream(thetruststore), strTsPass.toCharArray());
                this.trustStoreManager = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                this.trustStoreManager.init(keyStore);
            }
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnrecoverableKeyException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void configureClientParameters(Client client) {
        TLSClientParameters tlsParams = new TLSClientParameters();
        tlsParams.setDisableCNCheck(true);
        if (this.keyStoreManager != null) {
            tlsParams.setKeyManagers(this.keyStoreManager.getKeyManagers());
        }
        if (this.trustStoreManager != null) {
            tlsParams.setTrustManagers(this.trustStoreManager.getTrustManagers());
        }
        FiltersType filters = new FiltersType();
        filters.getInclude().add(".*_EXPORT_.*");
        filters.getInclude().add(".*_EXPORT1024_.*");
        filters.getInclude().add(".*_WITH_DES_.*");
        filters.getInclude().add(".*_WITH_AES_.*");
        filters.getInclude().add(".*_WITH_RC4_.*");
        filters.getInclude().add(".*_WITH_3DES_.*");
        filters.getInclude().add(".*_WITH_NULL_.*");
        filters.getInclude().add(".*_DH_anon_.*");
        tlsParams.setCipherSuitesFilter(filters);
        HTTPConduit conduit = (HTTPConduit)client.getConduit();
        conduit.setTlsClientParameters(tlsParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getLocalWsdlUrl(URL url) {
        SSLContext ctx;
        try {
            ctx = SSLContext.getInstance("TLS");
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("TLS-Algorithm could not be found in the ssl context");
            e.printStackTrace();
            return null;
        }
        try {
            if (this.keyStoreManager != null && this.trustStoreManager != null) {
                ctx.init(this.keyStoreManager.getKeyManagers(), this.trustStoreManager.getTrustManagers(), null);
            } else if (this.keyStoreManager == null) {
                ctx.init(null, this.trustStoreManager.getTrustManagers(), null);
            } else if (this.trustStoreManager == null) {
                ctx.init(this.keyStoreManager.getKeyManagers(), null, null);
            }
        }
        catch (KeyManagementException e) {
            this.getLogger().finest("SSL context could not be initialized");
            e.printStackTrace();
            return null;
        }
        Socket socket = null;
        PrintWriter out = null;
        BufferedReader in = null;
        BufferedWriter wout = null;
        try {
            String inputLine;
            int port = url.getPort();
            if (port == -1) {
                port = url.getDefaultPort();
            }
            socket = (SSLSocket)ctx.getSocketFactory().createSocket(url.getHost(), port);
            ((SSLSocket)socket).startHandshake();
            out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(socket.getOutputStream())));
            out.println("GET " + url.getFile() + " HTTP/1.0");
            out.println("Host: " + url.getHost());
            out.println();
            out.flush();
            if (out.checkError()) {
                System.out.println("SSLSocketClient: " + out.getClass().getName() + " error");
            }
            in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            File myWsdl = File.createTempFile("wsdl", null);
            wout = new BufferedWriter(new FileWriter(myWsdl));
            boolean readLine = false;
            while ((inputLine = in.readLine()) != null) {
                if (inputLine.startsWith("<?xml")) {
                    readLine = true;
                }
                if (!readLine) continue;
                wout.write(inputLine + "\n");
            }
            URL uRL = myWsdl.toURI().toURL();
            return uRL;
        }
        catch (UnknownHostException e) {
            this.getLogger().finest("The host: " + url.getHost() + " is unknown or could not be determined at the moment");
            e.printStackTrace();
            URL uRL = null;
            return uRL;
        }
        catch (SSLHandshakeException e) {
            this.getLogger().finest("Error during SSL handshake between client and server. If you enabled client authentication for the server, then you must pass keystore parameters to the client");
            e.printStackTrace();
            URL uRL = null;
            return uRL;
        }
        catch (IOException e) {
            this.getLogger().finest("An error occured during creation of the ssl socket.");
            e.printStackTrace();
            URL uRL = null;
            return uRL;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
            if (wout != null) {
                try {
                    wout.close();
                }
                catch (IOException e) {}
            }
            if (out != null) {
                out.close();
            }
        }
    }
}

