/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.deser;

import java.io.IOException;
import java.util.Map;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.KeyDeserializer;
import org.codehaus.jackson.map.deser.StdDeserializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapDeserializer
extends StdDeserializer<Map<?, ?>> {
    final Class<Map<Object, Object>> _mapClass;
    final KeyDeserializer _keyDeserializer;
    final JsonDeserializer<Object> _valueDeserializer;

    public MapDeserializer(Class<?> mapClass, KeyDeserializer keyDeser, JsonDeserializer<Object> valueDeser) {
        super(Map.class);
        this._mapClass = mapClass;
        this._keyDeserializer = keyDeser;
        this._valueDeserializer = valueDeser;
    }

    @Override
    public Map<?, ?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Map<Object, Object> result;
        if (jp.getCurrentToken() != JsonToken.START_OBJECT) {
            throw ctxt.mappingException(this._mapClass);
        }
        try {
            result = this._mapClass.newInstance();
        }
        catch (Exception e) {
            throw ctxt.instantiationException(this._mapClass, e);
        }
        KeyDeserializer keyDes = this._keyDeserializer;
        JsonDeserializer<Object> valueDes = this._valueDeserializer;
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = jp.getCurrentName();
            String key = keyDes == null ? fieldName : keyDes.deserializeKey(fieldName, ctxt);
            JsonToken t = jp.nextToken();
            Object value = t == JsonToken.VALUE_NULL ? null : valueDes.deserialize(jp, ctxt);
            result.put(key, value);
        }
        return result;
    }
}

