/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.ser;

import java.io.IOException;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.ResolvableSerializer;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.SerializerFactory;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.ser.BasicSerializerFactory;
import org.codehaus.jackson.map.ser.FailingSerializer;
import org.codehaus.jackson.map.ser.ReadOnlyClassToSerializerMap;
import org.codehaus.jackson.map.ser.SerializerCache;
import org.codehaus.jackson.map.ser.StdKeySerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StdSerializerProvider
extends SerializerProvider {
    static final boolean CACHE_UNKNOWN_MAPPINGS = false;
    public static final JsonSerializer<Object> DEFAULT_NULL_KEY_SERIALIZER = new FailingSerializer("Null key for a Map not allower in Json (use a converting NullKeySerializer?)");
    public static final JsonSerializer<Object> DEFAULT_KEY_SERIALIZER = new StdKeySerializer();
    public static final JsonSerializer<Object> DEFAULT_UNKNOWN_SERIALIZER = new JsonSerializer<Object>(){

        @Override
        public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws JsonMappingException {
            throw new JsonMappingException("No serializer found for class " + value.getClass().getName() + " (and no bean properties discovered to create bean serializer)");
        }
    };
    protected final SerializerFactory _serializerFactory;
    protected final SerializerCache _serializerCache;
    protected JsonSerializer<Object> _unknownTypeSerializer = DEFAULT_UNKNOWN_SERIALIZER;
    protected JsonSerializer<Object> _keySerializer = DEFAULT_KEY_SERIALIZER;
    protected JsonSerializer<Object> _nullValueSerializer = BasicSerializerFactory.NullSerializer.instance;
    protected JsonSerializer<Object> _nullKeySerializer = DEFAULT_NULL_KEY_SERIALIZER;
    protected final ReadOnlyClassToSerializerMap _knownSerializers;

    public StdSerializerProvider() {
        super(null);
        this._serializerFactory = null;
        this._serializerCache = new SerializerCache();
        this._knownSerializers = null;
    }

    protected StdSerializerProvider(SerializationConfig config, StdSerializerProvider src, SerializerFactory f) {
        super(config);
        if (config == null) {
            throw new NullPointerException();
        }
        this._serializerFactory = f;
        this._serializerCache = src._serializerCache;
        this._unknownTypeSerializer = src._unknownTypeSerializer;
        this._keySerializer = src._keySerializer;
        this._nullValueSerializer = src._nullValueSerializer;
        this._nullKeySerializer = src._nullKeySerializer;
        this._knownSerializers = this._serializerCache.getReadOnlyLookupMap();
    }

    protected StdSerializerProvider createInstance(SerializationConfig config, SerializerFactory jsf) {
        return new StdSerializerProvider(config, this, jsf);
    }

    @Override
    public final void serializeValue(SerializationConfig config, JsonGenerator jgen, Object value, SerializerFactory jsf) throws IOException, JsonGenerationException {
        if (jsf == null) {
            throw new IllegalArgumentException("Can not pass null serializerFactory");
        }
        StdSerializerProvider inst = this.createInstance(config, jsf);
        if (inst.getClass() != this.getClass()) {
            throw new IllegalStateException("Broken serializer provider: createInstance returned instance of type " + inst.getClass() + "; blueprint of type " + this.getClass());
        }
        inst._serializeValue(jgen, value);
    }

    @Override
    public boolean hasSerializerFor(SerializationConfig config, Class<?> cls, SerializerFactory jsf) {
        return this.createInstance(config, jsf)._findExplicitSerializer(cls) != null;
    }

    protected void _serializeValue(JsonGenerator jgen, Object value) throws IOException, JsonProcessingException {
        JsonSerializer<Object> ser = value == null ? this.getNullValueSerializer() : this.findValueSerializer(value.getClass());
        try {
            ser.serialize(value, jgen, this);
        }
        catch (JsonMappingException jme) {
            throw jme;
        }
        catch (Exception e) {
            throw new JsonMappingException(e.getMessage(), e);
        }
    }

    public void setKeySerializer(JsonSerializer<Object> ks) {
        if (ks == null) {
            throw new IllegalArgumentException("Can not pass null JsonSerializer");
        }
        this._keySerializer = ks;
    }

    public void setNullValueSerializer(JsonSerializer<Object> nvs) {
        if (nvs == null) {
            throw new IllegalArgumentException("Can not pass null JsonSerializer");
        }
        this._nullValueSerializer = nvs;
    }

    public void setNullKeySerializer(JsonSerializer<Object> nks) {
        if (nks == null) {
            throw new IllegalArgumentException("Can not pass null JsonSerializer");
        }
        this._nullKeySerializer = nks;
    }

    @Override
    public JsonSerializer<Object> findValueSerializer(Class<?> type) throws JsonMappingException {
        JsonSerializer<Object> ser = this._knownSerializers.get(type);
        if (ser != null) {
            return ser;
        }
        ser = this._serializerCache.findSerializer(type);
        if (ser != null) {
            return ser;
        }
        ser = this._createAndCacheSerializer(type);
        if (ser == null) {
            ser = this.getUnknownTypeSerializer(type);
        }
        return ser;
    }

    @Override
    public JsonSerializer<Object> getKeySerializer() {
        return this._keySerializer;
    }

    @Override
    public JsonSerializer<Object> getNullKeySerializer() {
        return this._nullKeySerializer;
    }

    @Override
    public JsonSerializer<Object> getNullValueSerializer() {
        return this._nullValueSerializer;
    }

    @Override
    public JsonSerializer<Object> getUnknownTypeSerializer(Class<?> unknownType) {
        return this._unknownTypeSerializer;
    }

    protected JsonSerializer<Object> _findExplicitSerializer(Class<?> type) {
        JsonSerializer<Object> ser = this._knownSerializers.get(type);
        if (ser != null) {
            return ser;
        }
        ser = this._serializerCache.findSerializer(type);
        if (ser != null) {
            return ser;
        }
        try {
            return this._createAndCacheSerializer(type);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected JsonSerializer<Object> _createAndCacheSerializer(Class<?> type) throws JsonMappingException {
        JsonSerializer<Object> ser;
        try {
            ser = this._createSerializer(type);
        }
        catch (IllegalArgumentException iae) {
            throw new JsonMappingException(iae.getMessage(), null, iae);
        }
        if (ser != null) {
            this._serializerCache.addSerializer(type, ser);
            if (ser instanceof ResolvableSerializer) {
                this._resolveSerializer((ResolvableSerializer)((Object)ser));
            }
        }
        return ser;
    }

    protected JsonSerializer<Object> _createSerializer(Class<?> type) throws JsonMappingException {
        return this._serializerFactory.createSerializer(type, this._config);
    }

    protected void _resolveSerializer(ResolvableSerializer ser) throws JsonMappingException {
        ser.resolve(this);
    }
}

