/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.deser;

import java.io.IOException;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.deser.StdDeserializer;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.ObjectNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonNodeDeserializer
extends StdDeserializer<JsonNode> {
    public static final JsonNodeDeserializer instance = new JsonNodeDeserializer();
    protected JsonNodeFactory _nodeFactory = JsonNodeFactory.instance;

    public JsonNodeDeserializer() {
        super(JsonNode.class);
    }

    public JsonNodeFactory getNodeFactory() {
        return this._nodeFactory;
    }

    public void setNodeFactory(JsonNodeFactory nf) {
        this._nodeFactory = nf;
    }

    @Override
    public JsonNode deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        switch (jp.getCurrentToken()) {
            case START_OBJECT: {
                ObjectNode node = this._nodeFactory.objectNode();
                while (jp.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = jp.getCurrentName();
                    jp.nextToken();
                    JsonNode value = this.deserialize(jp, ctxt);
                    JsonNode old = node.put(fieldName, value);
                    if (old == null) continue;
                    this._handleDuplicateField(fieldName, node, old, value);
                }
                return node;
            }
            case START_ARRAY: {
                ArrayNode node = this._nodeFactory.arrayNode();
                while (jp.nextToken() != JsonToken.END_ARRAY) {
                    node.add(this.deserialize(jp, ctxt));
                }
                return node;
            }
            case VALUE_STRING: {
                return this._nodeFactory.textNode(jp.getText());
            }
            case VALUE_NUMBER_INT: {
                if (jp.getNumberType() == JsonParser.NumberType.INT) {
                    return this._nodeFactory.numberNode(jp.getIntValue());
                }
                return this._nodeFactory.numberNode(jp.getLongValue());
            }
            case VALUE_NUMBER_FLOAT: {
                if (jp.getNumberType() == JsonParser.NumberType.BIG_DECIMAL) {
                    return this._nodeFactory.numberNode(jp.getDecimalValue());
                }
                return this._nodeFactory.numberNode(jp.getDoubleValue());
            }
            case VALUE_TRUE: {
                return this._nodeFactory.booleanNode(true);
            }
            case VALUE_FALSE: {
                return this._nodeFactory.booleanNode(false);
            }
            case VALUE_NULL: {
                return this._nodeFactory.nullNode();
            }
        }
        throw ctxt.mappingException(this.getValueClass());
    }

    protected void _reportProblem(JsonParser jp, String msg) throws JsonMappingException {
        throw new JsonMappingException(msg, jp.getTokenLocation());
    }

    protected void _handleDuplicateField(String fieldName, ObjectNode objectNode, JsonNode oldValue, JsonNode newValue) throws JsonProcessingException {
    }
}

