/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.groovy.gossip;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.mojo.groovy.gossip.AbstractLogger;
import org.codehaus.mojo.groovy.gossip.Event;
import org.codehaus.mojo.groovy.gossip.InternalLogger;
import org.codehaus.mojo.groovy.gossip.Level;
import org.codehaus.mojo.groovy.gossip.config.Configurator;
import org.codehaus.mojo.groovy.gossip.model.EffectiveProfile;
import org.codehaus.mojo.groovy.gossip.model.Logger;
import org.slf4j.ILoggerFactory;

public final class Gossip
implements ILoggerFactory {
    private final InternalLogger log = InternalLogger.getLogger(this.getClass());
    private final Map loggers;
    private EffectiveProfile profile;
    private LoggerImpl root = new LoggerImpl("<ROOT>", Level.INFO);
    static final /* synthetic */ boolean $assertionsDisabled;

    public Gossip() {
        this.loggers = new HashMap();
        this.profile = new Configurator().configure();
        this.prime();
    }

    private void prime() {
        this.log.trace("Priming");
        Iterator iter = this.profile.loggers().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String name = (String)entry.getKey();
            Logger node = (Logger)entry.getValue();
            LoggerImpl logger = (LoggerImpl)this.getLogger(name);
            logger.level = node.getLevel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.slf4j.Logger getLogger(String name) {
        LoggerImpl logger;
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        Map map = this.loggers;
        synchronized (map) {
            Object obj = this.loggers.get(name);
            if (obj == null) {
                logger = new LoggerImpl(name);
                this.loggers.put(name, logger);
                this.log.trace("Created logger: {}", (Object)logger);
                this.updateParents(logger);
            } else if (obj instanceof ProvisionNode) {
                logger = new LoggerImpl(name);
                this.loggers.put(name, logger);
                this.log.trace("Replaced provision node with logger: {}", (Object)logger);
                this.updateChildren((ProvisionNode)obj, logger);
                this.updateParents(logger);
            } else if (obj instanceof LoggerImpl) {
                logger = (LoggerImpl)((Object)obj);
                this.log.trace("Using cached logger: {}", (Object)logger);
            } else {
                throw new InternalError();
            }
        }
        return logger;
    }

    private void updateParents(LoggerImpl logger) {
        if (!$assertionsDisabled && logger == null) {
            throw new AssertionError();
        }
        String name = logger.getName();
        int length = name.length();
        this.log.trace("Update parents: {}", name);
        boolean parentFound = false;
        int i = name.lastIndexOf(46, length - 1);
        while (i >= 0) {
            String key = name.substring(0, i);
            Object obj = this.loggers.get(key);
            if (obj == null) {
                ProvisionNode pn = new ProvisionNode(logger);
                this.loggers.put(key, pn);
            } else {
                if (obj instanceof LoggerImpl) {
                    parentFound = true;
                    logger.parent = (LoggerImpl)((Object)obj);
                    break;
                }
                if (obj instanceof ProvisionNode) {
                    ((ProvisionNode)obj).add(logger);
                } else {
                    throw new InternalError();
                }
            }
            i = name.lastIndexOf(46, i - 1);
        }
        if (!parentFound) {
            logger.parent = this.root;
        }
    }

    private void updateChildren(ProvisionNode pn, LoggerImpl logger) {
        if (!$assertionsDisabled && pn == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && logger == null) {
            throw new AssertionError();
        }
        int last = pn.size();
        for (int i = 0; i < last; ++i) {
            LoggerImpl l = (LoggerImpl)((Object)pn.get(i));
            this.log.trace("Updating child {}", l.name);
            if (((LoggerImpl)l).parent.name.startsWith(logger.name)) continue;
            logger.parent = l.parent;
            l.parent = logger;
        }
    }

    static {
        $assertionsDisabled = !Gossip.class.desiredAssertionStatus();
    }

    private class ProvisionNode
    extends ArrayList {
        static final /* synthetic */ boolean $assertionsDisabled;

        private ProvisionNode(LoggerImpl logger) {
            if (!$assertionsDisabled && logger == null) {
                throw new AssertionError();
            }
            this.add(logger);
        }

        static {
            $assertionsDisabled = !(class$org$codehaus$mojo$groovy$gossip$Gossip == null ? (class$org$codehaus$mojo$groovy$gossip$Gossip = Gossip.class$("org.codehaus.mojo.groovy.gossip.Gossip")) : class$org$codehaus$mojo$groovy$gossip$Gossip).desiredAssertionStatus();
        }
    }

    private class LoggerImpl
    extends AbstractLogger {
        private Level level;
        private Level cachedLevel;
        private LoggerImpl parent;
        static final /* synthetic */ boolean $assertionsDisabled;

        private LoggerImpl(String name, Level level) {
            super(name);
            this.level = level;
        }

        private LoggerImpl(String name) {
            this(name, (Level)null);
        }

        private Level findEffectiveLevel() {
            LoggerImpl logger = this;
            while (logger != null) {
                if (logger.level != null) {
                    return logger.level;
                }
                logger = logger.parent;
            }
            return null;
        }

        private Level getEffectiveLevel() {
            if (this.cachedLevel == null) {
                this.cachedLevel = this.findEffectiveLevel();
            }
            return this.cachedLevel;
        }

        protected boolean isEnabled(Level level) {
            if (!$assertionsDisabled && level == null) {
                throw new AssertionError();
            }
            return this.getEffectiveLevel().id <= level.id;
        }

        protected void doLog(Level level, String message, Throwable cause) {
            Gossip.this.profile.filter(new Event(this, level, message, cause));
        }

        static {
            $assertionsDisabled = !(class$org$codehaus$mojo$groovy$gossip$Gossip == null ? (class$org$codehaus$mojo$groovy$gossip$Gossip = Gossip.class$("org.codehaus.mojo.groovy.gossip.Gossip")) : class$org$codehaus$mojo$groovy$gossip$Gossip).desiredAssertionStatus();
        }
    }
}

