/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.groovy.gossip.config;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.codehaus.mojo.groovy.gossip.InternalLogger;
import org.codehaus.mojo.groovy.gossip.config.ConfigurationException;
import org.codehaus.mojo.groovy.gossip.config.Context;
import org.codehaus.mojo.groovy.gossip.model.Configuration;
import org.codehaus.mojo.groovy.gossip.model.Filter;
import org.codehaus.mojo.groovy.gossip.model.Logger;
import org.codehaus.mojo.groovy.gossip.model.Profile;
import org.codehaus.mojo.groovy.gossip.model.Source;
import org.codehaus.mojo.groovy.gossip.model.Trigger;
import org.codehaus.mojo.groovy.gossip.model.render.Renderer;

public class ConfigurationFactory {
    private final InternalLogger log = InternalLogger.getLogger(this.getClass());
    private ClassLoader classLoader;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ConfigurationFactory(ClassLoader cl) {
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        this.classLoader = cl;
    }

    public ConfigurationFactory() {
        this(null);
    }

    public Configuration create(URL url) throws Exception {
        if (!$assertionsDisabled && url == null) {
            throw new AssertionError();
        }
        this.log.debug("Configuring from: {}", url);
        Configuration config = new Configuration();
        Context ctx = this.createContext(url);
        String tmp = ctx.get("version", (String)null);
        if (!config.getVersion().equals(tmp)) {
            throw new ConfigurationException("Invalid configuration version: " + tmp + ", expected: " + config.getVersion());
        }
        Properties props = this.createProperties(ctx.child("properties"));
        config.properties().putAll((Map<?, ?>)props);
        this.configureSources(config, ctx);
        this.configureProfiles(config, ctx);
        this.log.debug("Configuration: {}", config);
        return config;
    }

    private void configureSources(Configuration config, Context ctx) {
        if (!$assertionsDisabled && config == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && ctx == null) {
            throw new AssertionError();
        }
        this.log.debug("Configuring sources: {}", ctx);
        if (!ctx.contains("sources")) {
            this.log.debug("Missing 'sources' property; skipping");
            return;
        }
        String[] names = ctx.get("sources", "").split(",");
        for (int i = 0; i < names.length; ++i) {
            String name = names[i].trim();
            if (name.length() == 0) {
                throw new ConfigurationException("Source name must not be blank");
            }
            try {
                Source source = this.createSource(ctx.get("source." + name, (String)null), ctx.child("source." + name));
                this.log.debug("Created source: {}", source);
                config.addSource(source);
                continue;
            }
            catch (Exception e) {
                this.log.error("Failed to create source: {}", name, e);
            }
        }
    }

    private Source createSource(String className, Context ctx) throws Exception {
        if (!$assertionsDisabled && className == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && ctx == null) {
            throw new AssertionError();
        }
        this.log.debug("Creating source: {}", className);
        Class type = this.loadClass(className);
        Source source = (Source)type.newInstance();
        Iterator iter = ctx.names().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = ctx.get(key, (String)null);
            this.maybeSet(source, key, value);
        }
        return source;
    }

    private void configureProfiles(Configuration config, Context ctx) {
        if (!$assertionsDisabled && config == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && ctx == null) {
            throw new AssertionError();
        }
        this.log.debug("Configuring profiles: {}", ctx);
        if (!ctx.contains("profiles")) {
            this.log.debug("Missing 'profiles' property; skipping");
            return;
        }
        String[] names = ctx.get("profiles", "").split(",");
        for (int i = 0; i < names.length; ++i) {
            String name = names[i].trim();
            if (name.length() == 0) {
                throw new ConfigurationException("Profile name must not be blank");
            }
            Profile profile = this.createProfile(name, ctx.child("profile." + name));
            this.log.debug("Created profile: {}", profile);
            config.addProfile(profile);
        }
    }

    private Profile createProfile(String name, Context ctx) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && ctx == null) {
            throw new AssertionError();
        }
        this.log.debug("Creating profile: {}");
        Profile profile = new Profile(name);
        Properties props = this.createProperties(ctx.child("properties"));
        profile.properties().putAll((Map<?, ?>)props);
        this.configureLoggers(profile, ctx.child("logger"));
        this.configureTriggers(profile, ctx);
        this.configureFilters(profile, ctx);
        return profile;
    }

    private void configureLoggers(Profile profile, Context ctx) {
        if (!$assertionsDisabled && profile == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && ctx == null) {
            throw new AssertionError();
        }
        this.log.debug("Configuring loggers: {}", ctx);
        Iterator iter = ctx.names().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            String value = ctx.get(name, (String)null);
            Logger logger = new Logger(name);
            logger.setLevel(value);
            this.log.debug("Created logger[{}]: {}", name, logger);
            profile.addLogger(logger);
        }
    }

    private void configureTriggers(Profile profile, Context ctx) {
        if (!$assertionsDisabled && profile == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && ctx == null) {
            throw new AssertionError();
        }
        this.log.debug("Configuring triggers: {}", ctx);
        if (!ctx.contains("triggers")) {
            this.log.debug("Missing 'triggers' property; skipping");
            return;
        }
        String[] names = ctx.get("triggers", "").split(",");
        for (int i = 0; i < names.length; ++i) {
            String name = names[i].trim();
            if (name.length() == 0) {
                throw new ConfigurationException("Trigger name must not be blank");
            }
            try {
                Trigger trigger = this.createTrigger(ctx.get("trigger." + name, (String)null), ctx.child("trigger." + name));
                this.log.debug("Created trigger: {}", trigger);
                profile.addTrigger(trigger);
                continue;
            }
            catch (Exception e) {
                this.log.error("Failed to create trigger: {}", name, e);
            }
        }
    }

    private Trigger createTrigger(String className, Context ctx) throws Exception {
        if (!$assertionsDisabled && className == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && ctx == null) {
            throw new AssertionError();
        }
        this.log.debug("Creating trigger: {}", className);
        Class type = this.loadClass(className);
        Trigger trigger = (Trigger)type.newInstance();
        Iterator iter = ctx.names().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            int i = key.indexOf(".");
            if (i != -1) {
                key = key.substring(0, i);
            }
            String value = ctx.get(key, (String)null);
            this.maybeSet(trigger, key, value);
        }
        return trigger;
    }

    private void configureFilters(Profile profile, Context ctx) {
        if (!$assertionsDisabled && profile == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && ctx == null) {
            throw new AssertionError();
        }
        this.log.debug("Configuring filters: {}", ctx);
        if (!ctx.contains("filters")) {
            this.log.debug("Missing 'filters' property; skipping");
            return;
        }
        String[] names = ctx.get("filters", "").split(",");
        for (int i = 0; i < names.length; ++i) {
            String name = names[i].trim();
            if (name.length() == 0) {
                throw new ConfigurationException("Filter name must not be blank");
            }
            try {
                Filter filter = this.createFilter(ctx.get("filter." + name, (String)null), ctx.child("filter." + name));
                this.log.debug("Created filter: {}", filter);
                profile.addFilter(filter);
                continue;
            }
            catch (Exception e) {
                this.log.error("Failed to create filter: {}", name, e);
            }
        }
    }

    private Filter createFilter(String className, Context ctx) throws Exception {
        if (!$assertionsDisabled && className == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && ctx == null) {
            throw new AssertionError();
        }
        this.log.debug("Creating filter: {}", className);
        Class type = this.loadClass(className);
        Filter filter = (Filter)type.newInstance();
        this.configureRenderer(filter, ctx);
        Iterator iter = ctx.names().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            int i = key.indexOf(".");
            if (i != -1) {
                key = key.substring(0, i);
            }
            if ("renderer".equals(key)) continue;
            Object value = ctx.get(key);
            this.maybeSet(filter, key, value);
        }
        return filter;
    }

    private void configureRenderer(Filter filter, Context ctx) throws Exception {
        if (!$assertionsDisabled && filter == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && ctx == null) {
            throw new AssertionError();
        }
        String className = ctx.get("renderer", (String)null);
        if (className != null) {
            Renderer renderer = this.createRenderer(className, ctx.child("renderer"));
            this.log.debug("Created renderer: {}", renderer);
            filter.setRenderer(renderer);
        }
    }

    private Renderer createRenderer(String className, Context ctx) throws Exception {
        if (!$assertionsDisabled && className == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && ctx == null) {
            throw new AssertionError();
        }
        this.log.debug("Creating renderer: {}", className);
        Class type = this.loadClass(className);
        Renderer renderer = (Renderer)type.newInstance();
        Iterator iter = ctx.names().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            int i = key.indexOf(".");
            if (i != -1) {
                key = key.substring(0, i);
            }
            String value = ctx.get(key, (String)null);
            this.maybeSet(renderer, key, value);
        }
        return renderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Context createContext(URL url) throws IOException {
        if (!$assertionsDisabled && url == null) {
            throw new AssertionError();
        }
        Properties props = new Properties();
        InputStream input = url.openStream();
        try {
            props.load(input);
        }
        finally {
            input.close();
        }
        if (this.log.isDebugEnabled()) {
            this.dumpProperties(props);
        }
        return new Context(props);
    }

    private Properties createProperties(Context ctx) {
        if (!$assertionsDisabled && ctx == null) {
            throw new AssertionError();
        }
        Properties props = new Properties();
        Iterator iter = ctx.names().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = ctx.get(key, (String)null);
            props.setProperty(key, value);
        }
        if (this.log.isDebugEnabled()) {
            this.dumpProperties(props);
        }
        return props;
    }

    private void dumpProperties(Properties props) {
        if (!props.isEmpty()) {
            this.log.debug("Properties: ");
            ArrayList<Object> keys = new ArrayList<Object>();
            keys.addAll(props.keySet());
            Collections.sort(keys);
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                String value = props.getProperty(name);
                this.log.debug("    {} -> {}", name, value);
            }
        }
    }

    private Class loadClass(String className) throws ClassNotFoundException {
        if (!$assertionsDisabled && className == null) {
            throw new AssertionError();
        }
        Class<?> type = this.classLoader.loadClass(className);
        this.log.trace("Loaded class: {}", type);
        return type;
    }

    private String capitalize(String string) {
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        int length = string.length();
        if (length == 0) {
            return string;
        }
        if (length == 1) {
            return string.toUpperCase();
        }
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    private void maybeSet(Object target, String name, Object value) {
        if (!$assertionsDisabled && target == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && value == null) {
            throw new AssertionError();
        }
        String tmp = "set" + this.capitalize(name);
        this.log.trace("Looking for setter: {}", tmp);
        Class<?> type = target.getClass();
        try {
            Method setter = type.getMethod(tmp, String.class);
            if (setter != null) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Setting '{}={}' via: {}", new Object[]{name, value, setter});
                }
                setter.invoke(target, value);
            }
        }
        catch (NoSuchMethodException e) {
            this.log.warn("No '{}(String)' found for: {} in: {}", new Object[]{tmp, name, type});
        }
        catch (Exception e) {
            this.log.error("Failed to set '{}={}'", new Object[]{name, value, e});
        }
    }

    static {
        $assertionsDisabled = !ConfigurationFactory.class.desiredAssertionStatus();
    }
}

