/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.groovy.gossip.config;

import java.net.URL;
import java.util.Iterator;
import org.codehaus.mojo.groovy.gossip.InternalLogger;
import org.codehaus.mojo.groovy.gossip.model.Configuration;
import org.codehaus.mojo.groovy.gossip.model.EffectiveProfile;
import org.codehaus.mojo.groovy.gossip.model.Profile;
import org.codehaus.mojo.groovy.gossip.model.Source;
import org.codehaus.mojo.groovy.gossip.model.filter.ConsoleWriter;
import org.codehaus.mojo.groovy.gossip.model.source.URLSource;
import org.codehaus.mojo.groovy.gossip.model.trigger.AlwaysTrigger;

public class Configurator {
    private static final String BOOTSTRAP_RESOURCE = "META-INF/org.codehaus.mojo.groovy.gossip/bootstrap.properties";
    private final InternalLogger log = InternalLogger.getLogger(this.getClass());
    static final /* synthetic */ boolean $assertionsDisabled;

    public EffectiveProfile configure() {
        Configuration root = new Configuration();
        EffectiveProfile profile = new EffectiveProfile();
        try {
            Configuration bootstrap = this.loadBootstrap();
            Configuration config = this.resolve(bootstrap, root);
            this.configureActiveProfiles(profile, config);
        }
        catch (Throwable t) {
            this.log.error("Failed to configure; using fall-back provider", t);
        }
        if (profile.profiles().isEmpty()) {
            this.log.debug("No profiles were activated; using fall-back");
            Profile p = this.createFallbackProfile();
            profile.addProfile(p);
        }
        return profile;
    }

    private void configureActiveProfiles(EffectiveProfile profile, Configuration config) throws Exception {
        if (!$assertionsDisabled && profile == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && config == null) {
            throw new AssertionError();
        }
        this.log.debug("Configure active profiles: {}", config);
        Iterator iter = config.profiles().iterator();
        while (iter.hasNext()) {
            Profile p = (Profile)iter.next();
            if (!p.isActive()) continue;
            this.log.debug("    {}", p);
            profile.addProfile(p);
        }
    }

    private Profile createFallbackProfile() {
        Profile p = new Profile("fallback");
        p.addTrigger(new AlwaysTrigger());
        p.addFilter(new ConsoleWriter("SYSOUT"));
        return p;
    }

    private Configuration loadBootstrap() throws Exception {
        URL url = this.getClass().getClassLoader().getResource(BOOTSTRAP_RESOURCE);
        URLSource source = new URLSource(url);
        return source.load();
    }

    private Configuration resolve(Configuration config, Configuration base) throws Exception {
        if (!$assertionsDisabled && config == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && base == null) {
            throw new AssertionError();
        }
        Iterator iter = config.sources().iterator();
        while (iter.hasNext()) {
            Source source = (Source)iter.next();
            Configuration loaded = null;
            try {
                loaded = source.load();
            }
            catch (Exception e) {
                this.log.error("Failed to load configuration from source: {}", source, e);
            }
            if (loaded == null) continue;
            this.resolve(loaded, base);
            base.merge(loaded);
        }
        return base;
    }

    static {
        $assertionsDisabled = !Configurator.class.desiredAssertionStatus();
    }
}

